/*
 * Decompiled with CFR 0.152.
 */
package restx;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.endpoint.Endpoint;
import restx.endpoint.EndpointParameterMapperRegistry;
import restx.entity.MatchedEntityRoute;
import restx.jackson.JsonEntityRouteBuilder;
import restx.jackson.StdJsonProducerEntityRoute;
import restx.security.PermissionFactory;

public class RestxRouter {
    private final ImmutableList<RestxRoute> routes;
    private final String name;
    private final String groupName;

    public static Builder builder() {
        return new Builder();
    }

    public RestxRouter(String name, RestxRoute ... routes) {
        this("default", name, routes);
    }

    public RestxRouter(String groupName, String name, RestxRoute ... routes) {
        this(groupName, name, (ImmutableList<RestxRoute>)ImmutableList.copyOf((Object[])routes));
    }

    public RestxRouter(String groupName, String name, ImmutableList<RestxRoute> routes) {
        this.groupName = (String)Preconditions.checkNotNull((Object)groupName);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.routes = (ImmutableList)Preconditions.checkNotNull(routes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, "");
        return sb.toString();
    }

    public void toString(StringBuilder sb, String indent) {
        sb.append(indent).append(this.name).append("[RestxRouter] {\n");
        for (RestxRoute route : this.routes) {
            sb.append(indent).append("    ").append(route).append("\n");
        }
        sb.append(indent).append("}");
    }

    public int getNbRoutes() {
        return this.routes.size();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public ImmutableList<RestxRoute> getRoutes() {
        return this.routes;
    }

    public String getName() {
        return this.name;
    }

    public static class Builder {
        private String groupName = "default";
        private String name = "default";
        private ObjectWriter writer;
        private ObjectReader reader;
        private EndpointParameterMapperRegistry registry;
        private List<RestxRoute> routes = Lists.newArrayList();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public Builder withMapper(ObjectMapper mapper) {
            if (this.writer == null) {
                this.writer = mapper.writer();
            }
            if (this.reader == null) {
                this.reader = mapper.reader();
            }
            return this;
        }

        public Builder withObjectWriter(ObjectWriter writer) {
            this.writer = writer;
            return this;
        }

        public Builder withObjectReader(ObjectReader reader) {
            this.reader = reader;
            return this;
        }

        public Builder withEndpointParameterMapperRegistry(EndpointParameterMapperRegistry registry) {
            this.registry = registry;
            return this;
        }

        public Builder addRoute(RestxRoute route) {
            this.routes.add(route);
            return this;
        }

        public <O> Builder GET(String path, Class<O> outputType, MatchedEntityRoute<Void, O> route) {
            return this.addRoute("GET", path, outputType, route);
        }

        public <O> Builder DELETE(String path, Class<O> outputType, MatchedEntityRoute<Void, O> route) {
            return this.addRoute("DELETE", path, outputType, route);
        }

        public <O> Builder HEAD(String path, Class<O> outputType, MatchedEntityRoute<Void, O> route) {
            return this.addRoute("HEAD", path, outputType, route);
        }

        public <O> Builder OPTIONS(String path, Class<O> outputType, MatchedEntityRoute<Void, O> route) {
            return this.addRoute("OPTIONS", path, outputType, route);
        }

        public <O> Builder addRoute(String method, String path, Class<O> outputType, MatchedEntityRoute<Void, O> route) {
            return this.addRoute(path, Endpoint.of(method, path), outputType, route);
        }

        public <O> Builder addRoute(String name, Endpoint endpoint, Class<O> outputType, MatchedEntityRoute<Void, O> route) {
            return this.addRoute(name, endpoint, (PermissionFactory)null, outputType, route);
        }

        public <O> Builder addRoute(String name, Endpoint endpoint, PermissionFactory permissionFactory, Class<O> outputType, final MatchedEntityRoute<Void, O> route) {
            this.routes.add(new StdJsonProducerEntityRoute<O>(name, outputType, this.writer.withType(outputType), endpoint, permissionFactory, this.registry){

                @Override
                protected Optional<O> doRoute(RestxRequest restxRequest, RestxResponse response, RestxRequestMatch match, Void i) throws IOException {
                    return route.route(restxRequest, match, i);
                }
            });
            return this;
        }

        public <I, O> Builder PUT(String path, Class<I> inputType, Class<O> outputType, MatchedEntityRoute<I, O> route) {
            return this.addRoute("PUT", path, inputType, outputType, route);
        }

        public <I, O> Builder POST(String path, Class<I> inputType, Class<O> outputType, MatchedEntityRoute<I, O> route) {
            return this.addRoute("POST", path, inputType, outputType, route);
        }

        public <I, O> Builder addRoute(String method, String path, Class<I> inputType, Class<O> outputType, MatchedEntityRoute<I, O> route) {
            return this.addRoute(path, new Endpoint(method, path), inputType, outputType, route);
        }

        public <I, O> Builder addRoute(String name, Endpoint endpoint, Class<I> inputType, Class<O> outputType, MatchedEntityRoute<I, O> route) {
            this.routes.add(new JsonEntityRouteBuilder().withObjectWriter(outputType, this.writer).withObjectReader(inputType, this.reader.withType(inputType)).name(name).registry(this.registry).endpoint(endpoint).matchedEntityRoute(route).build());
            return this;
        }

        public RestxRouter build() {
            return new RestxRouter(this.groupName, this.name, (ImmutableList<RestxRoute>)ImmutableList.copyOf(this.routes));
        }
    }
}

