/*
 * Decompiled with CFR 0.152.
 */
package restx;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import restx.RestxFilter;
import restx.RestxRoute;
import restx.RestxRouteFilter;
import restx.RestxRouter;
import restx.RestxRouting;
import restx.factory.BillOfMaterials;
import restx.factory.BoundlessComponentBox;
import restx.factory.Factory;
import restx.factory.Machine;
import restx.factory.MachineEngine;
import restx.factory.Name;
import restx.factory.NamedComponent;
import restx.factory.SatisfiedBOM;
import restx.factory.SingleNameFactoryMachine;
import restx.factory.StdMachineEngine;

@Machine
public class RoutingMachine
extends SingleNameFactoryMachine<RestxRouting> {
    public RoutingMachine() {
        super(0, (MachineEngine)new StdMachineEngine<RestxRouting>(Name.of(RestxRouting.class), BoundlessComponentBox.FACTORY){
            private final Factory.Query<RestxFilter> filters = Factory.Query.byClass(RestxFilter.class);
            private final Factory.Query<RestxRouteFilter> routeFilters = Factory.Query.byClass(RestxRouteFilter.class);
            private final Factory.Query<RestxRouter> routers = Factory.Query.byClass(RestxRouter.class);
            private final Factory.Query<RestxRoute> routes = Factory.Query.byClass(RestxRoute.class);

            public BillOfMaterials getBillOfMaterial() {
                return BillOfMaterials.of((Factory.Query[])new Factory.Query[]{this.filters, this.routeFilters, this.routers, this.routes});
            }

            protected RestxRouting doNewComponent(SatisfiedBOM satisfiedBOM) {
                ArrayList r = Lists.newArrayList();
                for (RestxRouter router : satisfiedBOM.getAsComponents(this.routers)) {
                    r.addAll(router.getRoutes());
                }
                Iterables.addAll((Collection)r, (Iterable)satisfiedBOM.getAsComponents(this.routes));
                return new RestxRouting((ImmutableList<NamedComponent<RestxFilter>>)ImmutableList.copyOf((Iterable)satisfiedBOM.get(this.filters)), (ImmutableList<NamedComponent<RestxRouteFilter>>)ImmutableList.copyOf((Iterable)satisfiedBOM.get(this.routeFilters)), (ImmutableList<RestxRoute>)ImmutableList.copyOf((Collection)r));
            }
        });
    }
}

