/*
 * Decompiled with CFR 0.152.
 */
package restx;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import restx.RestxRequestMatch;

public class StdRestxRequestMatch
implements RestxRequestMatch {
    private final String pattern;
    private final String path;
    private final ImmutableMap<String, String> pathParams;
    private final ImmutableMap<String, ? extends Object> otherParams;

    public StdRestxRequestMatch(String path) {
        this(path, path, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    public StdRestxRequestMatch(String pattern, String path) {
        this(pattern, path, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    public StdRestxRequestMatch(String pattern, String path, ImmutableMap<String, String> pathParams) {
        this(pattern, path, pathParams, (ImmutableMap<String, ? extends Object>)ImmutableMap.of());
    }

    public StdRestxRequestMatch(String pattern, String path, ImmutableMap<String, String> pathParams, ImmutableMap<String, ? extends Object> otherParams) {
        this.pattern = (String)Preconditions.checkNotNull((Object)pattern);
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.pathParams = (ImmutableMap)Preconditions.checkNotNull(pathParams);
        this.otherParams = (ImmutableMap)Preconditions.checkNotNull(otherParams);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getPathParam(String paramName) {
        String v = (String)this.pathParams.get((Object)paramName);
        if (v == null) {
            throw new IllegalStateException(String.format("path parameter %s was not found", paramName));
        }
        return v;
    }

    @Override
    public ImmutableMap<String, String> getPathParams() {
        return this.pathParams;
    }

    @Override
    public ImmutableMap<String, ? extends Object> getOtherParams() {
        return this.otherParams;
    }

    public String toString() {
        return "StdRestxHandlerMatch{pattern='" + this.pattern + '\'' + ", path='" + this.path + '\'' + ", pathParams=" + this.pathParams + ", otherParams=" + this.otherParams + '}';
    }
}

