/*
 * Decompiled with CFR 0.152.
 */
package restx;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.RestxRequest;
import restx.RestxResponse;
import restx.http.HttpStatus;

public class WebException
extends RuntimeException {
    private static final Logger logger = LoggerFactory.getLogger(WebException.class);
    private final HttpStatus status;

    public WebException(HttpStatus status) {
        super(status.getDesc());
        this.status = status;
    }

    public WebException(HttpStatus status, String message) {
        super(message);
        this.status = status;
    }

    public WebException(String message) {
        super(message);
        this.status = HttpStatus.BAD_REQUEST;
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    public String getContentType() {
        return "text/plain";
    }

    public String getContent() {
        return this.getMessage();
    }

    public void writeTo(RestxRequest restxRequest, RestxResponse restxResponse) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("request raised WebException - " + restxRequest, (Throwable)this);
        }
        restxResponse.setStatus(this.getStatus());
        restxResponse.setContentType(this.getContentType());
        restxResponse.getWriter().print(this.getContent());
    }
}

