/*
 * Decompiled with CFR 0.152.
 */
package restx.entity;

import java.io.IOException;
import java.lang.reflect.Type;
import restx.RestxContext;
import restx.RestxRequest;
import restx.RestxResponse;
import restx.entity.EntityResponseWriter;
import restx.http.HttpStatus;

public abstract class AbstractEntityResponseWriter<T>
implements EntityResponseWriter<T> {
    private final Type type;
    private final String contentType;

    protected AbstractEntityResponseWriter(Type type, String contentType) {
        this.type = type;
        this.contentType = contentType;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void sendResponse(HttpStatus status, T value, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
        resp.setStatus(status);
        resp.setContentType(this.contentType);
        this.writeHeaders(value, req, resp, ctx);
        ctx.getLifecycleListener().onBeforeWriteContent(req, resp);
        this.write(value, req, resp, ctx);
        ctx.getLifecycleListener().onAfterWriteContent(req, resp);
    }

    protected void writeHeaders(T value, RestxRequest req, RestxResponse resp, RestxContext ctx) {
    }

    protected abstract void write(T var1, RestxRequest var2, RestxResponse var3, RestxContext var4) throws IOException;
}

