/*
 * Decompiled with CFR 0.152.
 */
package restx.entity;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import java.lang.reflect.Type;
import restx.entity.EntityDefaultContentTypeProvider;

public class EntityContentTypeResolver {
    private final Iterable<EntityDefaultContentTypeProvider> entityDefaultContentTypeProviders;

    public EntityContentTypeResolver(Iterable<EntityDefaultContentTypeProvider> entityDefaultContentTypeProviders) {
        this.entityDefaultContentTypeProviders = entityDefaultContentTypeProviders;
    }

    public String resolveContentType(final Type type, Optional<String> contentType) {
        return (String)contentType.or((Supplier)new Supplier<String>(){

            public String get() {
                for (EntityDefaultContentTypeProvider entityDefaultContentTypeProvider : EntityContentTypeResolver.this.entityDefaultContentTypeProviders) {
                    Optional<String> contentType = entityDefaultContentTypeProvider.mayProvideDefaultContentType(type);
                    if (!contentType.isPresent()) continue;
                    return (String)contentType.get();
                }
                throw new IllegalStateException(String.format("no EntityDefaultContentTypeProvider provided for %s.\n\nThe list of providers are:\n%s.\n\nBy default RESTX should provide a 'application/json' default content type for any type\nthrough JsonEntityDefaultContentTypeProvider, if you haven't removed it on purpose you\nmay have to double check your restx distribution and your classpath\n", type, Joiner.on((String)"\n\t").join(EntityContentTypeResolver.this.entityDefaultContentTypeProviders)));
            }
        });
    }
}

