/*
 * Decompiled with CFR 0.152.
 */
package restx.entity;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import java.lang.reflect.Type;
import restx.entity.EntityContentTypeResolver;
import restx.entity.EntityDefaultContentTypeProvider;
import restx.entity.EntityResponseWriter;
import restx.entity.EntityResponseWriterFactory;
import restx.factory.Component;

@Component
public class EntityResponseWriterRegistry {
    private final EntityContentTypeResolver entityContentTypeResolver;
    private final Iterable<EntityResponseWriterFactory> entityResponseWriterFactories;

    public EntityResponseWriterRegistry(Iterable<EntityDefaultContentTypeProvider> entityDefaultContentTypeProviders, Iterable<EntityResponseWriterFactory> entityResponseWriterFactories) {
        this.entityContentTypeResolver = new EntityContentTypeResolver(entityDefaultContentTypeProviders);
        this.entityResponseWriterFactories = entityResponseWriterFactories;
    }

    public <T> EntityResponseWriter<T> build(Type type, Optional<String> contentType) {
        String ct = this.entityContentTypeResolver.resolveContentType(type, contentType);
        for (EntityResponseWriterFactory writerFactory : this.entityResponseWriterFactories) {
            Optional writer = writerFactory.mayBuildFor(type, ct);
            if (!writer.isPresent()) continue;
            return (EntityResponseWriter)writer.get();
        }
        throw new IllegalStateException(String.format("no EntityResponseWriter built for %s %s.\n\nThe list of factories are:\n%s.\n\nThis may be because the content type '%s' is not handled by your RESTX install.\n\nPossible causes:\n  - you set the content type manually and mistyped it\n  - you are missing the EntityResponseWriterFactory for this content type in your classpath\n", type, ct, Joiner.on((String)"\n\t").join(this.entityResponseWriterFactories), ct));
    }
}

