/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Collections;
import restx.RestxRequest;
import restx.security.AcceptedCORS;
import restx.security.CORSAuthorizer;

public abstract class CORS {
    private static final RejectedCORS REJECTED_CORS = new RejectedCORS();

    static CORS check(Iterable<CORSAuthorizer> authorizers, RestxRequest request, String origin, String method, String restxPath) {
        for (CORSAuthorizer authorizer : authorizers) {
            Optional<CORS> cors = authorizer.checkCORS(request, origin, method, restxPath);
            if (!cors.isPresent()) continue;
            return (CORS)cors.get();
        }
        return CORS.reject();
    }

    public static CORS reject() {
        return REJECTED_CORS;
    }

    public static CORS accept(String origin, Collection<String> methods) {
        return new AcceptedCORS(origin, methods, Collections.emptyList(), (Optional<Boolean>)Optional.absent(), 1728000);
    }

    public static CORS accept(String origin, Collection<String> methods, int maxAge) {
        return new AcceptedCORS(origin, methods, Collections.emptyList(), (Optional<Boolean>)Optional.absent(), maxAge);
    }

    public static CORS accept(String origin, Collection<String> methods, Collection<String> headers, int maxAge) {
        return new AcceptedCORS(origin, methods, headers, (Optional<Boolean>)Optional.absent(), maxAge);
    }

    public static CORS accept(String origin, Collection<String> methods, Collection<String> headers, Optional<Boolean> credentials, int maxAge) {
        return new AcceptedCORS(origin, methods, headers, credentials, maxAge);
    }

    public abstract boolean isAccepted();

    private static final class RejectedCORS
    extends CORS {
        private RejectedCORS() {
        }

        @Override
        public boolean isAccepted() {
            return false;
        }
    }
}

