/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import restx.security.RestxSession;

public class GuavaEntryCacheManager
implements RestxSession.Definition.EntryCacheManager {
    @Override
    public <T> RestxSession.Definition.CachedEntry<T> getCachedEntry(RestxSession.Definition.Entry<T> entry) {
        return new GuavaCacheSessionDefinitionEntry<T>(entry.getKey(), this.getLoadingCacheFor(entry));
    }

    protected <T> LoadingCache<String, T> getLoadingCacheFor(RestxSession.Definition.Entry<T> entry) {
        return this.getCacheBuilder(entry).build(this.getCacheLoaderFor(entry));
    }

    protected <T> CacheLoader<String, T> getCacheLoaderFor(final RestxSession.Definition.Entry<T> entry) {
        return new CacheLoader<String, T>(){

            public T load(String key) throws Exception {
                return entry.getValueForId(key).orNull();
            }
        };
    }

    protected <T> CacheBuilder<Object, Object> getCacheBuilder(RestxSession.Definition.Entry<T> entry) {
        return CacheBuilder.newBuilder().maximumSize(1000L);
    }

    public static class GuavaCacheSessionDefinitionEntry<T>
    implements RestxSession.Definition.CachedEntry<T> {
        private final LoadingCache<String, T> loadingCache;
        private final String key;

        public GuavaCacheSessionDefinitionEntry(String key, LoadingCache<String, T> loadingCache) {
            this.key = key;
            this.loadingCache = loadingCache;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Optional<T> getValueForId(String valueId) {
            try {
                return Optional.fromNullable((Object)this.loadingCache.get((Object)valueId));
            }
            catch (CacheLoader.InvalidCacheLoadException e) {
                return Optional.absent();
            }
            catch (ExecutionException e) {
                throw new RuntimeException("impossible to load object from cache using valueid " + valueId + " for " + this.key + ": " + e.getMessage(), e);
            }
        }

        @Override
        public void invalidateCacheFor(String valueId) {
            this.loadingCache.invalidate((Object)valueId);
        }

        @Override
        public void invalidateCache() {
            this.loadingCache.invalidateAll();
        }
    }
}

