/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.Duration;
import restx.factory.Component;
import restx.security.RestxPrincipal;

public class RestxSession {
    private static final ThreadLocal<RestxSession> current = new ThreadLocal();
    private final Definition definition;
    private final ImmutableMap<String, String> valueidsByKey;
    private final Duration expires;
    private final Optional<? extends RestxPrincipal> principal;

    static void setCurrent(RestxSession ctx) {
        if (ctx == null) {
            current.remove();
        } else {
            current.set(ctx);
        }
    }

    public static RestxSession current() {
        return current.get();
    }

    RestxSession(Definition definition, ImmutableMap<String, String> valueidsByKey, Optional<? extends RestxPrincipal> principal, Duration expires) {
        this.definition = definition;
        this.valueidsByKey = valueidsByKey;
        this.principal = principal;
        this.expires = expires;
    }

    public RestxSession invalidateCaches() {
        for (Map.Entry entry : this.valueidsByKey.entrySet()) {
            ((Definition.CachedEntry)this.definition.getEntry((String)entry.getKey()).get()).invalidateCacheFor((String)entry.getValue());
        }
        return this;
    }

    public <T> Optional<T> get(Class<T> clazz, String key) {
        return RestxSession.getValue(this.definition, clazz, key, (String)this.valueidsByKey.get((Object)key));
    }

    static <T> Optional<T> getValue(Definition definition, Class<T> clazz, String key, String valueid) {
        if (valueid == null) {
            return Optional.absent();
        }
        return ((Definition.CachedEntry)definition.getEntry(key).get()).getValueForId(valueid);
    }

    public RestxSession expires(Duration duration) {
        return this.mayUpdateCurrent(new RestxSession(this.definition, this.valueidsByKey, this.principal, duration));
    }

    public Duration getExpires() {
        return this.expires;
    }

    public <T> RestxSession define(Class<T> clazz, String key, String valueid) {
        if (!this.definition.hasEntryForKey(key)) {
            throw new IllegalArgumentException("undefined context key: " + key + "." + " Keys defined are: " + this.definition.entriesKeySet());
        }
        HashMap newValueidsByKey = Maps.newHashMap();
        newValueidsByKey.putAll(this.valueidsByKey);
        if (valueid == null) {
            newValueidsByKey.remove(key);
        } else {
            newValueidsByKey.put(key, valueid);
        }
        return this.mayUpdateCurrent(new RestxSession(this.definition, (ImmutableMap<String, String>)ImmutableMap.copyOf((Map)newValueidsByKey), this.principal, this.expires));
    }

    public RestxSession authenticateAs(RestxPrincipal principal) {
        return this.mayUpdateCurrent(new RestxSession(this.definition, this.valueidsByKey, (Optional<? extends RestxPrincipal>)Optional.of((Object)principal), this.expires)).define(RestxPrincipal.class, "principal", principal.getName());
    }

    public RestxSession clearPrincipal() {
        return this.mayUpdateCurrent(new RestxSession(this.definition, this.valueidsByKey, (Optional<? extends RestxPrincipal>)Optional.absent(), this.expires)).define(RestxPrincipal.class, "principal", null);
    }

    public Optional<? extends RestxPrincipal> getPrincipal() {
        return this.principal;
    }

    private RestxSession mayUpdateCurrent(RestxSession newSession) {
        if (this == RestxSession.current()) {
            current.set(newSession);
        }
        return newSession;
    }

    ImmutableMap<String, String> valueidsByKeyMap() {
        return this.valueidsByKey;
    }

    public void runIn(Runnable runnable) {
        RestxSession current = RestxSession.current();
        RestxSession.setCurrent(this);
        try {
            runnable.run();
        }
        finally {
            RestxSession.setCurrent(current);
        }
    }

    @Component
    public static class Definition {
        private final ImmutableMap<String, CachedEntry<?>> entries;

        public Definition(EntryCacheManager cacheManager, Iterable<Entry> entries) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Entry entry : entries) {
                builder.put((Object)entry.getKey(), cacheManager.getCachedEntry(entry));
            }
            this.entries = builder.build();
        }

        public ImmutableSet<String> entriesKeySet() {
            return this.entries.keySet();
        }

        public boolean hasEntryForKey(String key) {
            return this.entries.containsKey((Object)key);
        }

        public <T> Optional<CachedEntry<T>> getEntry(String key) {
            return Optional.fromNullable((Object)((CachedEntry)this.entries.get((Object)key)));
        }

        public void invalidateAllCaches() {
            for (CachedEntry entry : this.entries.values()) {
                entry.invalidateCache();
            }
        }

        public static interface EntryCacheManager {
            public <T> CachedEntry<T> getCachedEntry(Entry<T> var1);
        }

        public static interface CachedEntry<T> {
            public String getKey();

            public Optional<? extends T> getValueForId(String var1);

            public void invalidateCacheFor(String var1);

            public void invalidateCache();
        }

        public static interface Entry<T> {
            public String getKey();

            public Optional<? extends T> getValueForId(String var1);
        }
    }
}

