/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.AbstractRouteLifecycleListener;
import restx.RestxContext;
import restx.RestxHandler;
import restx.RestxHandlerMatch;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouteFilter;
import restx.StdRestxRequestMatch;
import restx.WebException;
import restx.factory.Component;
import restx.factory.Name;
import restx.http.HttpStatus;
import restx.security.PermissionFactory;
import restx.security.RestxPrincipal;
import restx.security.RestxSession;
import restx.security.RestxSessionCookieDescriptor;
import restx.security.Signer;

@Component(priority=-200)
public class RestxSessionCookieFilter
implements RestxRouteFilter,
RestxHandler {
    public static final Name<RestxSessionCookieFilter> NAME = Name.of(RestxSessionCookieFilter.class, (String)"RestxSessionCookieFilter");
    public static final String COOKIE_SIGNER_NAME = "CookieSigner";
    private static final String EXPIRES = "_expires";
    private static final Logger logger = LoggerFactory.getLogger(RestxSessionCookieFilter.class);
    private final RestxSession.Definition sessionDefinition;
    private final ObjectMapper mapper;
    private final Signer signer;
    private final PermissionFactory permissionFactory;
    private final RestxSessionCookieDescriptor restxSessionCookieDescriptor;
    private final RestxSession emptySession;

    public RestxSessionCookieFilter(RestxSession.Definition sessionDefinition, @Named(value="FrontObjectMapper") ObjectMapper mapper, @Named(value="CookieSigner") Signer signer, PermissionFactory permissionFactory, RestxSessionCookieDescriptor restxSessionCookieDescriptor) {
        this.sessionDefinition = sessionDefinition;
        this.mapper = mapper;
        this.signer = signer;
        this.permissionFactory = permissionFactory;
        this.restxSessionCookieDescriptor = restxSessionCookieDescriptor;
        this.emptySession = new RestxSession(sessionDefinition, (ImmutableMap<String, String>)ImmutableMap.of(), (Optional<? extends RestxPrincipal>)Optional.absent(), Duration.ZERO);
    }

    @Override
    public Optional<RestxHandlerMatch> match(RestxRoute route) {
        return Optional.of((Object)new RestxHandlerMatch(new StdRestxRequestMatch("/*"), this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
        final RestxSession session = this.buildContextFromRequest(req);
        if ("recording".equals(ctx.getMode())) {
            this.sessionDefinition.invalidateAllCaches();
        }
        RestxSession.setCurrent(session);
        try {
            AbstractRouteLifecycleListener lifecycleListener = new AbstractRouteLifecycleListener(){

                @Override
                public void onBeforeWriteContent(RestxRequest req, RestxResponse resp) {
                    RestxSession newSession = RestxSession.current();
                    if (newSession != session) {
                        RestxSessionCookieFilter.this.updateSessionInClient(resp, newSession);
                    }
                }
            };
            ctx.nextHandlerMatch().handle(req, resp, ctx.withListener(lifecycleListener));
        }
        finally {
            RestxSession.setCurrent(null);
        }
    }

    public RestxSession buildContextFromRequest(RestxRequest req) throws IOException {
        Optional<String> su;
        String restxSessionCookieName = this.restxSessionCookieDescriptor.getCookieName();
        String cookie = (String)req.getCookieValue(restxSessionCookieName).or((Object)"");
        if (cookie.trim().isEmpty()) {
            return this.emptySession;
        }
        String sig = (String)req.getCookieValue(this.restxSessionCookieDescriptor.getCookieSignatureName()).or((Object)"");
        if (!this.signer.verify(cookie, sig)) {
            logger.warn("invalid restx session signature. session was: {}. Ignoring session cookie.", (Object)cookie);
            return this.emptySession;
        }
        Map<String, String> entries = this.readEntries(cookie);
        DateTime expires = DateTime.parse((String)entries.remove(EXPIRES));
        if (expires.isBeforeNow()) {
            return this.emptySession;
        }
        Duration expiration = req.isPersistentCookie(restxSessionCookieName) ? new Duration((ReadableInstant)DateTime.now(), (ReadableInstant)expires) : Duration.ZERO;
        ImmutableMap valueidsByKey = ImmutableMap.copyOf(entries);
        String principalName = (String)valueidsByKey.get((Object)"principal");
        Optional<RestxPrincipal> principalOptional = RestxSession.getValue(this.sessionDefinition, RestxPrincipal.class, "principal", principalName);
        if (principalOptional.isPresent() && this.permissionFactory.hasRole("restx-admin").has((RestxPrincipal)principalOptional.get(), Collections.emptyMap()).isPresent() && (su = req.getHeader("RestxSu")).isPresent() && !Strings.isNullOrEmpty((String)((String)su.get()))) {
            try {
                entries.putAll(this.readEntries((String)su.get()));
                valueidsByKey = ImmutableMap.copyOf(entries);
                principalName = (String)valueidsByKey.get((Object)"principal");
                principalOptional = RestxSession.getValue(this.sessionDefinition, RestxPrincipal.class, "principal", principalName);
                logger.info("restx-admin sudoing request with {}", su.get());
            }
            catch (Exception e) {
                logger.warn("restx-admin tried sudoing request with {}, but it failed: {}", su.get(), (Object)e.toString());
                throw new WebException(HttpStatus.BAD_REQUEST, "invalid su session '" + (String)su.get() + "': " + e.toString());
            }
        }
        return new RestxSession(this.sessionDefinition, (ImmutableMap<String, String>)valueidsByKey, principalOptional, expiration);
    }

    protected Map<String, String> readEntries(String cookie) throws IOException {
        return (Map)this.mapper.readValue(cookie, Map.class);
    }

    private void updateSessionInClient(RestxResponse resp, RestxSession session) {
        ImmutableMap<String, String> cookiesMap = this.toCookiesMap(session);
        if (cookiesMap.isEmpty()) {
            resp.clearCookie(this.restxSessionCookieDescriptor.getCookieName(), this.restxSessionCookieDescriptor);
            resp.clearCookie(this.restxSessionCookieDescriptor.getCookieSignatureName(), this.restxSessionCookieDescriptor);
        } else {
            for (Map.Entry cookie : cookiesMap.entrySet()) {
                logger.debug("setting cookie: {} {}", cookie.getKey(), cookie.getValue());
                resp.addCookie((String)cookie.getKey(), (String)cookie.getValue(), this.restxSessionCookieDescriptor, session.getExpires());
            }
        }
    }

    public ImmutableMap<String, String> toCookiesMap(RestxSession session) {
        try {
            ImmutableMap<String, String> sessionMap = session.valueidsByKeyMap();
            if (sessionMap.isEmpty()) {
                return ImmutableMap.of();
            }
            HashMap map = Maps.newHashMap(sessionMap);
            map.put(EXPIRES, DateTime.now().plusDays(30).toString());
            String sessionJson = this.mapper.writeValueAsString((Object)map);
            return ImmutableMap.of((Object)this.restxSessionCookieDescriptor.getCookieName(), (Object)sessionJson, (Object)this.restxSessionCookieDescriptor.getCookieSignatureName(), (Object)this.signer.sign(sessionJson));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "RestxSessionCookieFilter";
    }
}

