/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import org.slf4j.MDC;
import restx.RestxContext;
import restx.RestxHandler;
import restx.RestxHandlerMatch;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouteFilter;
import restx.StdRestxRequestMatch;
import restx.factory.Component;
import restx.security.RestxPrincipal;
import restx.security.RestxSession;
import restx.security.Sessions;

@Component(priority=-110)
public class RestxSessionLogFilter
implements RestxRouteFilter,
RestxHandler {
    private final Sessions sessions;

    public RestxSessionLogFilter(Sessions sessions) {
        this.sessions = sessions;
    }

    @Override
    public Optional<RestxHandlerMatch> match(RestxRoute route) {
        return Optional.of((Object)new RestxHandlerMatch(new StdRestxRequestMatch("/*"), this));
    }

    @Override
    public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
        RestxSession session = RestxSession.current();
        ImmutableMap<String, String> metadata = this.prepareSessionStatsMetadata(req, session);
        if (session.getPrincipal().isPresent()) {
            String name = ((RestxPrincipal)session.getPrincipal().get()).getName();
            this.sessions.touch(name, metadata);
            MDC.put((String)"principal", (String)name);
        } else {
            this.sessions.touch("anonymous@" + req.getClientAddress(), metadata);
        }
        ctx.nextHandlerMatch().handle(req, resp, ctx);
    }

    protected ImmutableMap<String, String> prepareSessionStatsMetadata(RestxRequest req, RestxSession session) {
        return ImmutableMap.of((Object)"clientAddress", (Object)req.getClientAddress(), (Object)"userAgent", (Object)req.getHeader("User-Agent").or((Object)"Unknown"));
    }
}

