/*
 * Decompiled with CFR 0.152.
 */
package restx.specs;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.StdRequest;
import restx.StdRestxRequestMatcher;
import restx.common.MoreResources;
import restx.factory.Component;
import restx.specs.RestxSpec;
import restx.specs.RestxSpecLoader;
import restx.specs.When;
import restx.specs.WhenHttpRequest;

@Component
public class RestxSpecRepository {
    private static final Logger logger = LoggerFactory.getLogger(RestxSpecRepository.class);
    private ImmutableMap<String, RestxSpec> allSpecs;
    private RestxSpecLoader specLoader;

    public RestxSpecRepository(RestxSpecLoader specLoader) {
        this.specLoader = specLoader;
    }

    public Iterable<String> findAll() {
        return this.findAllSpecs().keySet();
    }

    public Optional<RestxSpec> findSpecById(String id) {
        return Optional.fromNullable((Object)this.findAllSpecs().get((Object)id));
    }

    public Iterable<String> findSpecsByOperation(String httpMethod, String path) {
        return this.filterSpecsByOperation(this.findAllSpecs(), httpMethod, path);
    }

    public Iterable<WhenHttpRequest> findSpecsByRequest(RestxRequest request) {
        return this.findWhensMatchingRequest(this.findAllSpecs(), request);
    }

    synchronized ImmutableMap<String, RestxSpec> findAllSpecs() {
        if (this.allSpecs == null) {
            this.allSpecs = ImmutableMap.copyOf(this.buildSpecsMap(false));
        }
        return this.allSpecs;
    }

    protected Map<String, RestxSpec> buildSpecsMap(boolean searchInSources) {
        LinkedHashMap specsMap = Maps.newLinkedHashMap();
        Map specs = MoreResources.findResources((String)"", (Pattern)Pattern.compile(".*\\.spec\\.yaml"), (boolean)searchInSources);
        for (final Map.Entry spec : specs.entrySet()) {
            try {
                specsMap.put(spec.getKey(), this.specLoader.load((String)spec.getKey(), new CharSource(){

                    public Reader openStream() throws IOException {
                        return new InputStreamReader(((URL)spec.getValue()).openStream(), Charsets.UTF_8);
                    }
                }));
            }
            catch (Exception e) {
                logger.warn("exception while loading restx spec " + spec + ": " + e, (Throwable)e);
            }
        }
        return specsMap;
    }

    Iterable<String> filterSpecsByOperation(ImmutableMap<String, RestxSpec> allSpecs, String httpMethod, String path) {
        StdRestxRequestMatcher matcher = new StdRestxRequestMatcher(httpMethod, path);
        ArrayList specs = Lists.newArrayList();
        block0: for (Map.Entry spec : allSpecs.entrySet()) {
            for (When when : ((RestxSpec)spec.getValue()).getWhens()) {
                Optional<? extends RestxRequestMatch> match;
                if (!(when instanceof WhenHttpRequest)) continue;
                WhenHttpRequest request = (WhenHttpRequest)when;
                String requestPath = request.getPath();
                if (!requestPath.startsWith("/")) {
                    requestPath = "/" + requestPath;
                }
                if (requestPath.indexOf("?") != -1) {
                    requestPath = requestPath.substring(0, requestPath.indexOf("?"));
                }
                if (!(match = matcher.match(request.getMethod(), requestPath)).isPresent()) continue;
                specs.add(spec.getKey());
                continue block0;
            }
        }
        return specs;
    }

    Iterable<WhenHttpRequest> findWhensMatchingRequest(ImmutableMap<String, RestxSpec> allSpecs, RestxRequest restxRequest) {
        ArrayList matchingRequestsSpecs = Lists.newArrayList();
        block0: for (Map.Entry spec : allSpecs.entrySet()) {
            for (When when : ((RestxSpec)spec.getValue()).getWhens()) {
                MapDifference difference;
                if (!(when instanceof WhenHttpRequest)) continue;
                WhenHttpRequest request = (WhenHttpRequest)when;
                String requestPath = request.getPath();
                if (!requestPath.startsWith("/")) {
                    requestPath = "/" + requestPath;
                }
                StdRequest stdRequest = StdRequest.builder().setBaseUri("http://restx.io").setHttpMethod(request.getMethod()).setFullPath(requestPath).build();
                if (!restxRequest.getHttpMethod().equals(stdRequest.getHttpMethod()) || !restxRequest.getRestxPath().equals(stdRequest.getRestxPath()) || !(difference = Maps.difference(restxRequest.getQueryParams(), stdRequest.getQueryParams())).entriesOnlyOnRight().isEmpty() || !difference.entriesDiffering().isEmpty()) continue;
                matchingRequestsSpecs.add(request);
                continue block0;
            }
        }
        return matchingRequestsSpecs;
    }
}

