/*
 * Decompiled with CFR 0.152.
 */
package restx.specs;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import restx.RestxRequest;
import restx.RestxRequestWrapper;
import restx.RestxResponse;
import restx.RestxResponseWrapper;
import restx.common.ThreadLocalMillisProvider;
import restx.http.HttpStatus;
import restx.security.RestxSessionCookieFilter;
import restx.specs.Given;
import restx.specs.GivenTime;
import restx.specs.RestxSpec;
import restx.specs.RestxSpecRecorder;
import restx.specs.ThenHttpResponse;
import restx.specs.WhenHttpRequest;

public class RestxSpecTape {
    private static final ReentrantLock lock = new ReentrantLock();
    private static final AtomicInteger specId = new AtomicInteger();
    private static final ThreadLocal<RestxSpecTape> specTape = new ThreadLocal();
    private final RestxRequest restxRequest;
    private final RestxResponse restxResponse;
    private final RestxSpecRecorder.RecordedSpec recordedSpec = new RestxSpecRecorder.RecordedSpec();
    private final Map<String, Given> givens = Maps.newLinkedHashMap();
    private final Set<RestxSpecRecorder.GivenRecorder> recorders;
    private final Set<AutoCloseable> givenTapes = Sets.newLinkedHashSet();
    private final RestxSessionCookieFilter sessionFilter;
    private final RestxSpec.Storage storage;
    private RestxRequest recordingRequest;
    private RestxResponse recordingResponse;
    private int id;

    RestxSpecTape(RestxRequest restxRequest, RestxResponse restxResponse, Set<RestxSpecRecorder.GivenRecorder> recorders, RestxSessionCookieFilter sessionFilter, RestxSpec.StorageSettings storageSettings) {
        this.storage = RestxSpec.Storage.with(storageSettings);
        try {
            lock.tryLock(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("in record mode only one request at a time can be processed, another request is currently being processed which is taking too much time");
        }
        this.recorders = recorders;
        this.restxRequest = restxRequest;
        this.restxResponse = restxResponse;
        this.sessionFilter = sessionFilter;
    }

    public RestxSpecRecorder.RecordedSpec close() {
        if (specTape.get() == this) {
            specTape.remove();
        }
        for (AutoCloseable givenTape : this.givenTapes) {
            try {
                givenTape.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ThreadLocalMillisProvider.setCurrentMillisSystem();
        lock.unlock();
        return this.recordedSpec;
    }

    public RestxSpecTape doRecord(final Optional<String> recordPath, Optional<String> recordTitle) throws IOException {
        specTape.set(this);
        for (RestxSpecRecorder.GivenRecorder recorder : this.recorders) {
            this.givenTapes.add(recorder.recordIn(this.givens));
        }
        DateTime now = DateTime.now();
        this.givens.put(GivenTime.class.getSimpleName() + "/now", new GivenTime(now));
        ThreadLocalMillisProvider.setCurrentMillisFixed((long)now.getMillis());
        this.recordedSpec.setRecordTime(now);
        Stopwatch stopwatch = Stopwatch.createStarted();
        System.out.print("RECORDING REQUEST...");
        final String method = this.restxRequest.getHttpMethod();
        final String path = this.restxRequest.getRestxUri().length() > 1 ? this.restxRequest.getRestxUri().substring(1) : this.restxRequest.getRestxUri();
        final ImmutableMap<String, String> cookies = this.sessionFilter.toCookiesMap(this.sessionFilter.buildContextFromRequest(this.restxRequest));
        final byte[] requestBody = ByteStreams.toByteArray((InputStream)this.restxRequest.getContentStream());
        System.out.println(" >> recorded request " + method + " " + path + " (" + requestBody.length + " bytes) -- " + stopwatch.stop());
        this.recordedSpec.setCapturedRequestSize(requestBody.length);
        this.id = specId.incrementAndGet();
        final String title = (String)recordTitle.or((Object)this.buildTitle(this.id, method, path));
        final String specPath = this.storage.buildPath(recordPath, title);
        this.recordingRequest = new RestxRequestWrapper(this.restxRequest){

            @Override
            public InputStream getContentStream() throws IOException {
                return new ByteArrayInputStream(requestBody);
            }
        };
        this.recordingResponse = new RestxResponseWrapper(this.restxResponse){
            private Stopwatch stopwatch;
            private ByteArrayOutputStream baos;
            private PrintWriter writer;
            private OutputStream realOS;
            public HttpStatus status;
            {
                super(restxResponse);
                this.stopwatch = Stopwatch.createUnstarted();
                this.status = HttpStatus.OK;
            }

            @Override
            public PrintWriter getWriter() throws IOException {
                if (this.writer == null) {
                    this.writer = super.getWriter();
                }
                return this.writer;
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                if (recordPath.isPresent()) {
                    super.setHeader("RestxSpecPath", specPath);
                }
                System.out.print("RECORDING RESPONSE...");
                this.stopwatch.start();
                this.realOS = super.getOutputStream();
                this.baos = new ByteArrayOutputStream();
                return this.baos;
            }

            @Override
            public HttpStatus getStatus() {
                return this.status;
            }

            @Override
            public RestxResponse setStatus(HttpStatus i) {
                super.setStatus(i);
                this.status = i;
                return null;
            }

            @Override
            public void close() throws Exception {
                if (this.isClosed()) {
                    return;
                }
                if (this.writer != null) {
                    this.writer.flush();
                }
                System.out.println(" >> recorded response (" + this.baos.size() + " bytes) -- " + this.stopwatch.stop());
                if (this.realOS != null) {
                    ByteStreams.copy((InputStream)ByteSource.wrap((byte[])this.baos.toByteArray()).openStream(), (OutputStream)this.realOS);
                }
                super.close();
                Iterator iterator = RestxSpecTape.this.givenTapes.iterator();
                while (iterator.hasNext()) {
                    AutoCloseable givenTape = (AutoCloseable)iterator.next();
                    try {
                        givenTape.close();
                        iterator.remove();
                    }
                    catch (Exception exception) {}
                }
                ThreadLocalMillisProvider.setCurrentMillisSystem();
                RestxSpec restxSpec = new RestxSpec(specPath, title, (ImmutableList<? extends Given>)ImmutableList.copyOf(RestxSpecTape.this.givens.values()), ImmutableList.of((Object)new WhenHttpRequest(method, path, (Map<String, String>)cookies, new String(requestBody, Charsets.UTF_8), new ThenHttpResponse(this.status.getCode(), this.baos.toString(Charsets.UTF_8.name())))));
                System.out.println("-----------------  RESTX SPEC  ---------------- \n" + restxSpec + "\n" + "------------------------------------------------");
                RestxSpecTape.this.recordedSpec.setId(RestxSpecTape.this.id).setSpec(restxSpec).setMethod(method).setPath(path).setDuration(new Duration((ReadableInstant)RestxSpecTape.this.recordedSpec.getRecordTime(), (ReadableInstant)DateTime.now())).setCapturedResponseSize(this.baos.size());
            }
        };
        return this;
    }

    private String buildTitle(int id, String method, String path) {
        int endIndex = path.indexOf(63);
        endIndex = endIndex == -1 ? path.length() : endIndex;
        return String.format("%03d %s %s", id, method, path.substring(0, endIndex));
    }

    public RestxRequest getRecordingRequest() {
        return this.recordingRequest;
    }

    public RestxResponse getRecordingResponse() {
        return this.recordingResponse;
    }
}

