/*
 * Decompiled with CFR 0.152.
 */
package restx.config;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.io.CharSource;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.common.ConfigElement;
import restx.common.RestxConfig;
import restx.common.StdRestxConfig;
import restx.config.ConfigSupplier;

public class ConfigLoader {
    private static final Logger logger = LoggerFactory.getLogger(ConfigLoader.class);
    private final String env;

    public ConfigLoader(Optional<String> env) {
        this.env = (String)env.or((Object)"default");
    }

    public ConfigSupplier fromResource(final String resource) {
        return new ConfigSupplier(){

            public RestxConfig get() {
                ArrayList<ConfigElement> elements = new ArrayList<ConfigElement>();
                ConfigLoader.this.loadAllFromResource(elements, resource);
                return StdRestxConfig.of(elements);
            }
        };
    }

    public ConfigSupplier fromFile(final String path) {
        return new ConfigSupplier(){

            public RestxConfig get() {
                ArrayList<ConfigElement> elements = new ArrayList<ConfigElement>();
                ConfigLoader.this.loadAllFromFile(elements, path);
                return StdRestxConfig.of(elements);
            }
        };
    }

    public String locationKeyForResource(String resource) {
        return resource.replace('/', '.') + ".location";
    }

    protected void loadAllFromResource(List<ConfigElement> elements, String resource) {
        String locationKey = this.locationKeyForResource(resource);
        String location = System.getProperty(locationKey);
        if (location != null) {
            Path path = Paths.get(location, new String[0]).toAbsolutePath();
            logger.info("loading {} settings from {}", (Object)resource, (Object)path);
            this.loadFileInto(path, elements);
        } else {
            logger.debug("system property `{}` is not set, no file to load to override settings from {}", (Object)locationKey, (Object)resource);
        }
        this.loadResourceInto(resource + "." + this.env + ".properties", elements);
        this.loadResourceInto(resource + ".properties", elements);
    }

    protected void loadAllFromFile(List<ConfigElement> elements, String path) {
        if (!path.endsWith(".properties")) {
            this.loadFileInto(Paths.get(path + "." + this.env + ".properties", new String[0]), elements);
            this.loadFileInto(Paths.get(path + ".properties", new String[0]), elements);
        }
        this.loadFileInto(Paths.get(path, new String[0]), elements);
    }

    protected void loadFileInto(Path path, List<ConfigElement> elements) {
        File file = path.toFile().getAbsoluteFile();
        if (!file.exists()) {
            logger.debug("no settings loaded from {}: file not available", (Object)file);
            return;
        }
        if (!file.isFile()) {
            logger.warn("no settings loaded from {}: this is not a file", (Object)file);
            return;
        }
        try {
            Iterable loadedElements = StdRestxConfig.parse((String)("file://" + file), (CharSource)Files.asCharSource((File)file, (Charset)Charsets.UTF_8)).elements();
            Iterables.addAll(elements, (Iterable)loadedElements);
            logger.debug("loaded {} elements from {}", (Object)Iterables.size((Iterable)loadedElements), (Object)file);
        }
        catch (IOException e) {
            logger.warn("can't load " + file + ": " + e.getMessage(), (Throwable)e);
        }
    }

    protected void loadResourceInto(String name, List<ConfigElement> elements) {
        URL r = Thread.currentThread().getContextClassLoader().getResource(name);
        if (r != null) {
            try {
                Iterable loadedElements = StdRestxConfig.parse((String)("classpath:" + name), (CharSource)Resources.asCharSource((URL)r, (Charset)Charsets.UTF_8)).elements();
                Iterables.addAll(elements, (Iterable)loadedElements);
                logger.debug("loaded {} elements from {}", (Object)Iterables.size((Iterable)loadedElements), (Object)name);
            }
            catch (IOException e) {
                logger.warn("can't load " + name + ": " + e.getMessage(), (Throwable)e);
            }
        } else {
            logger.debug("no settings loaded from {}: resource not available", (Object)name);
        }
    }
}

