/*
 * Decompiled with CFR 0.152.
 */
package restx.factory;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collections;
import restx.factory.ComponentBox;
import restx.factory.Name;
import restx.factory.NamedComponent;
import restx.factory.SatisfiedBOM;
import restx.factory.Warehouse;

public class FilteredWarehouse
implements Warehouse {
    private final Predicate<Name<?>> filter;
    private final Warehouse original;

    public static FilteredWarehouse excludingClasses(Warehouse original, Class<?> ... classes) {
        return FilteredWarehouse.builder(original).excludingClasses(classes).build();
    }

    public static FilteredWarehouse excludingClasses(Warehouse original, Iterable<Class<?>> classes) {
        return FilteredWarehouse.builder(original).excludingClasses(classes).build();
    }

    public static FilteredWarehouse excludingNames(Warehouse original, Name<?> ... names) {
        return FilteredWarehouse.builder(original).excludingNames(names).build();
    }

    public static FilteredWarehouse excludingNames(Warehouse original, Iterable<Name<?>> names) {
        return FilteredWarehouse.builder(original).excludingNames(names).build();
    }

    @SafeVarargs
    public static FilteredWarehouse excluding(Warehouse original, Predicate<Name<?>> ... filters) {
        return FilteredWarehouse.builder(original).excluding(filters).build();
    }

    public static FilteredWarehouse excluding(Warehouse original, Iterable<Predicate<Name<?>>> filters) {
        return FilteredWarehouse.builder(original).excluding(filters).build();
    }

    public static FilteredWarehouseBuilder builder(Warehouse original) {
        return new FilteredWarehouseBuilder(original);
    }

    private FilteredWarehouse(Warehouse original, Predicate<Name<?>> filter) {
        this.original = (Warehouse)Preconditions.checkNotNull((Object)original);
        this.filter = (Predicate)Preconditions.checkNotNull(filter);
    }

    @Override
    public String getId() {
        return this.original.getId();
    }

    @Override
    public ImmutableList<Warehouse> getProviders() {
        return this.original.getProviders();
    }

    @Override
    public <T> Optional<Warehouse.StoredBox<T>> getStoredBox(Name<T> name) {
        if (this.isFiltered(name)) {
            return Optional.absent();
        }
        return this.original.getStoredBox(name);
    }

    @Override
    public <T> Optional<NamedComponent<T>> checkOut(Name<T> name) {
        if (this.isFiltered(name)) {
            return Optional.absent();
        }
        return this.original.checkOut(name);
    }

    @Override
    public <T> void checkIn(ComponentBox<T> componentBox, SatisfiedBOM satisfiedBOM) {
        this.original.checkIn(componentBox, satisfiedBOM);
    }

    @Override
    public Iterable<Name<?>> listNames() {
        return Iterables.filter(this.original.listNames(), (Predicate)new Predicate<Name<?>>(){

            public boolean apply(Name<?> name) {
                return !FilteredWarehouse.this.isFiltered(name);
            }
        });
    }

    @Override
    public Iterable<Name<?>> listDependencies(Name name) {
        if (this.isFiltered(name)) {
            return Collections.emptySet();
        }
        return this.original.listDependencies(name);
    }

    @Override
    public void close() {
        this.original.close();
    }

    private boolean isFiltered(Name<?> name) {
        return this.filter.apply(name);
    }

    public static class FilteredWarehouseBuilder {
        private final Warehouse original;
        private final ImmutableList.Builder<Predicate<Name<?>>> predicatesBuilder = ImmutableList.builder();

        private FilteredWarehouseBuilder(Warehouse original) {
            this.original = original;
        }

        public FilteredWarehouseBuilder excludingClasses(Class<?> ... classes) {
            return this.excludingClasses((Iterable<Class<?>>)ImmutableSet.copyOf((Object[])classes));
        }

        public FilteredWarehouseBuilder excludingClasses(Iterable<Class<?>> classes) {
            final ImmutableSet classesSet = ImmutableSet.copyOf(classes);
            if (!classesSet.isEmpty()) {
                this.predicatesBuilder.add((Object)new Predicate<Name<?>>(){

                    public boolean apply(Name<?> name) {
                        return classesSet.contains(name.getClazz());
                    }
                });
            }
            return this;
        }

        public FilteredWarehouseBuilder excludingNames(Name<?> ... names) {
            return this.excludingNames((Iterable<Name<?>>)ImmutableSet.copyOf((Object[])names));
        }

        public FilteredWarehouseBuilder excludingNames(Iterable<Name<?>> names) {
            final ImmutableSet namesSet = ImmutableSet.copyOf(names);
            if (!namesSet.isEmpty()) {
                this.predicatesBuilder.add((Object)new Predicate<Name<?>>(){

                    public boolean apply(Name<?> name) {
                        return namesSet.contains(name);
                    }
                });
            }
            return this;
        }

        @SafeVarargs
        public final FilteredWarehouseBuilder excluding(Predicate<Name<?>> ... predicates) {
            this.predicatesBuilder.add((Object[])predicates);
            return this;
        }

        public FilteredWarehouseBuilder excluding(Iterable<Predicate<Name<?>>> predicates) {
            this.predicatesBuilder.addAll(predicates);
            return this;
        }

        public FilteredWarehouse build() {
            final ImmutableList predicates = this.predicatesBuilder.build();
            return new FilteredWarehouse(this.original, new Predicate<Name<?>>(){

                public boolean apply(Name<?> name) {
                    return Predicates.or((Iterable)predicates).apply(name);
                }
            });
        }
    }
}

