/*
 * Decompiled with CFR 0.152.
 */
package restx.factory;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import restx.factory.Name;

public final class NamedComponent<T> {
    private final Name<T> name;
    private final int priority;
    private final T component;

    public static <T> Function<NamedComponent<T>, T> toComponent() {
        return new Function<NamedComponent<T>, T>(){

            public T apply(NamedComponent<T> namedComponent) {
                return namedComponent.getComponent();
            }
        };
    }

    public static <T> Function<NamedComponent<T>, Name<T>> toName() {
        return new Function<NamedComponent<T>, Name<T>>(){

            public Name<T> apply(NamedComponent<T> namedComponent) {
                return namedComponent.getName();
            }
        };
    }

    public static <T> NamedComponent<T> of(Class<T> clazz, String name, T component) {
        return new NamedComponent<T>(new Name<T>(clazz, name), component);
    }

    public static <T> NamedComponent<T> of(Class<T> clazz, String name, int priority, T component) {
        return new NamedComponent<T>(new Name<T>(clazz, name), priority, component);
    }

    public NamedComponent(Name<T> name, T component) {
        this(name, 0, component);
    }

    public NamedComponent(Name<T> name, int priority, T component) {
        this.name = (Name)Preconditions.checkNotNull(name);
        this.priority = priority;
        this.component = Preconditions.checkNotNull(component);
    }

    public Name<T> getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public T getComponent() {
        return this.component;
    }

    public String toString() {
        return "NamedComponent{name=" + this.name + ", priority=" + this.priority + ", component=" + this.component + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedComponent that = (NamedComponent)o;
        if (!this.component.equals(that.component)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.component.hashCode();
        return result;
    }
}

