/*
 * Decompiled with CFR 0.152.
 */
package restx.factory;

import java.lang.reflect.Type;
import java.util.Objects;
import restx.common.TypeReference;
import restx.common.Types;

public class ParamDef<T> {
    private final String name;
    private final TypeReference<T> typeRef;
    private final Class<T> primitiveType;
    private final Class rawType;

    public ParamDef(TypeReference<T> typeRef, String name) {
        this(name, typeRef, null);
    }

    public ParamDef(Class<T> primitiveType, String name) {
        this(name, null, primitiveType);
    }

    protected ParamDef(ParamDef other) {
        this(other.name, other.typeRef, other.primitiveType);
    }

    protected ParamDef(String name, TypeReference<T> typeRef, Class<T> primitiveType) {
        this.name = name;
        this.typeRef = typeRef;
        this.primitiveType = primitiveType;
        this.rawType = Types.getRawType((Type)this.getType());
    }

    public static <T> ParamDef<T> of(TypeReference<T> type, String name) {
        return new ParamDef<T>(type, name);
    }

    public static <T> ParamDef<T> of(Class<T> rawType, String name) {
        return new ParamDef<T>(rawType, name);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.isPrimitiveType() ? this.primitiveType : this.typeRef.getType();
    }

    public boolean isPrimitiveType() {
        return this.primitiveType != null;
    }

    public Class getRawType() {
        return this.rawType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParamDef)) {
            return false;
        }
        ParamDef paramDef = (ParamDef)o;
        return Objects.equals(this.name, paramDef.name) && Objects.equals(this.getType(), paramDef.getType());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.getType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ParamDef{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", type=").append(this.getType());
        sb.append('}');
        return sb.toString();
    }
}

