/*
 * Decompiled with CFR 0.152.
 */
package restx.factory;

import com.google.common.base.Preconditions;
import restx.factory.BoundlessComponentBox;
import restx.factory.NamedComponent;
import restx.factory.NoDepsMachineEngine;
import restx.factory.SatisfiedBOM;
import restx.factory.SingleNameFactoryMachine;

public class SingletonFactoryMachine<C>
extends SingleNameFactoryMachine<C> {
    private final NamedComponent<C> component;

    public SingletonFactoryMachine(int priority, final NamedComponent<C> component) {
        super(priority, new NoDepsMachineEngine<C>(component.getName(), priority, BoundlessComponentBox.FACTORY){

            @Override
            public C doNewComponent(SatisfiedBOM satisfiedBOM) {
                return component.getComponent();
            }
        });
        this.component = (NamedComponent)Preconditions.checkNotNull(component, (Object)"component must not be null");
    }

    @Override
    public String toString() {
        return "SingletonFactoryMachine{component=" + this.component + '}';
    }
}

