/*
 * Decompiled with CFR 0.152.
 */
package restx.factory;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import restx.factory.BoundlessComponentBox;
import restx.factory.FactoryMachine;
import restx.factory.MachineEngine;
import restx.factory.Name;
import restx.factory.NoDepsMachineEngine;
import restx.factory.SatisfiedBOM;

public class SystemPropertyFactoryMachine
implements FactoryMachine {
    @Override
    public boolean canBuild(Name<?> name) {
        return name.getClazz() == String.class && System.getProperty(name.getName()) != null;
    }

    @Override
    public <T> MachineEngine<T> getEngine(final Name<T> name) {
        return new NoDepsMachineEngine<T>(name, this.priority(), BoundlessComponentBox.FACTORY){

            @Override
            protected T doNewComponent(SatisfiedBOM satisfiedBOM) {
                return Objects.firstNonNull((Object)System.getProperty(name.getName()), (Object)"");
            }
        };
    }

    @Override
    public <T> Set<Name<T>> nameBuildableComponents(Class<T> componentClass) {
        if (componentClass != String.class) {
            return Collections.emptySet();
        }
        LinkedHashSet<Name<T>> names = new LinkedHashSet<Name<T>>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            names.add(Name.of(String.class, (String)entry.getKey()));
        }
        return names;
    }

    @Override
    public int priority() {
        return -1000;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

