/*
 * Decompiled with CFR 0.152.
 */
package restx.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.common.MoreFiles;
import restx.server.WebServer;
import restx.server.WebServerBase;
import restx.server.WebServerSupplier;

public class Jetty8WebServer
extends WebServerBase {
    private static final Logger logger = LoggerFactory.getLogger(Jetty8WebServer.class);
    private Server server;
    private String webInfLocation;

    public Jetty8WebServer(String appBase, int aPort) {
        this(null, appBase, aPort, null);
    }

    public Jetty8WebServer(String webInfLocation, String appBase, int port, String bindInterface) {
        super((String)Preconditions.checkNotNull((Object)appBase), port, bindInterface, "Jetty8", "org.eclipse.jetty", "jetty-server");
        if (webInfLocation != null) {
            MoreFiles.checkFileExists((String)webInfLocation);
        }
        this.webInfLocation = webInfLocation;
    }

    protected void _start() throws Exception {
        this.server = new Server();
        this.server.setThreadPool(this.createThreadPool());
        this.server.addConnector((Connector)this.createConnector());
        this.server.setHandler((Handler)this.createHandlers(this.createContext()));
        this.server.setStopAtShutdown(true);
        this.server.start();
    }

    public void await() throws InterruptedException {
        this.server.join();
    }

    protected void _stop() throws Exception {
        this.server.stop();
        this.server = null;
    }

    protected ThreadPool createThreadPool() {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMinThreads(1);
        threadPool.setMaxThreads(Math.max(10, Runtime.getRuntime().availableProcessors()));
        return threadPool;
    }

    protected SelectChannelConnector createConnector() {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.port);
        connector.setHost(this.bindInterface);
        return connector;
    }

    protected HandlerCollection createHandlers(WebAppContext webAppContext) {
        HandlerList contexts = new HandlerList();
        contexts.setHandlers(new Handler[]{webAppContext});
        HandlerCollection result = new HandlerCollection();
        result.setHandlers(new Handler[]{contexts});
        return result;
    }

    protected WebAppContext createContext() {
        final WebAppContext ctx = new WebAppContext();
        ctx.setContextPath("/");
        ctx.setWar(this.appBase);
        if (!Strings.isNullOrEmpty((String)this.webInfLocation)) {
            ctx.setDescriptor(this.webInfLocation);
        }
        HashLoginService loginService = new HashLoginService();
        loginService.setIdentityService((IdentityService)new DefaultIdentityService());
        ctx.getSecurityHandler().setLoginService((LoginService)loginService);
        ctx.getSecurityHandler().setIdentityService(loginService.getIdentityService());
        ctx.addLifeCycleListener((LifeCycle.Listener)new AbstractLifeCycle.AbstractLifeCycleListener(){

            public void lifeCycleStarting(LifeCycle event) {
                ctx.getServletContext().setInitParameter("restx.baseServerUri", Jetty8WebServer.this.baseUrl());
                ctx.getServletContext().setInitParameter("restx.serverId", Jetty8WebServer.this.getServerId());
            }
        });
        return ctx;
    }

    public static WebServerSupplier jettyWebServerSupplier(final String webInfLocation, final String appBase) {
        return new WebServerSupplier(){

            public WebServer newWebServer(int port) {
                return new Jetty8WebServer(webInfLocation, appBase, port, "0.0.0.0");
            }
        };
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("usage: jetty-run <appbase> [<port>]");
            System.exit(1);
        }
        String appBase = args[0];
        int port = args.length > 1 ? Integer.parseInt(args[1]) : 8086;
        new Jetty8WebServer(appBase + "WEB-INF/web.xml", appBase, port, "0.0.0.0").startAndAwait();
    }
}

