/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.IllegalReferenceCountException;
import io.rsocket.Payload;
import io.rsocket.frame.FrameHeaderCodec;
import io.rsocket.frame.FrameType;

public class MetadataPushFrameCodec {
    public static ByteBuf encodeReleasingPayload(ByteBufAllocator allocator, Payload payload) {
        if (!payload.hasMetadata()) {
            throw new IllegalStateException("Metadata  push requires to have metadata present in the given Payload");
        }
        ByteBuf metadata = payload.metadata().retain();
        try {
            payload.release();
        }
        catch (IllegalReferenceCountException e) {
            metadata.release();
            throw e;
        }
        return MetadataPushFrameCodec.encode(allocator, metadata);
    }

    public static ByteBuf encode(ByteBufAllocator allocator, ByteBuf metadata) {
        ByteBuf header = FrameHeaderCodec.encodeStreamZero(allocator, FrameType.METADATA_PUSH, 256);
        return allocator.compositeBuffer(2).addComponents(true, new ByteBuf[]{header, metadata});
    }

    public static ByteBuf metadata(ByteBuf byteBuf) {
        byteBuf.markReaderIndex();
        int headerSize = FrameHeaderCodec.size();
        int metadataLength = byteBuf.readableBytes() - headerSize;
        byteBuf.skipBytes(headerSize);
        ByteBuf metadata = byteBuf.readSlice(metadataLength);
        byteBuf.resetReaderIndex();
        return metadata;
    }
}

