/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.metadata;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.CharsetUtil;
import io.rsocket.metadata.WellKnownMimeType;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class MimeTypeMetadataCodec {
    private static final int STREAM_METADATA_KNOWN_MASK = 128;
    private static final byte STREAM_METADATA_LENGTH_MASK = 127;

    private MimeTypeMetadataCodec() {
    }

    public static ByteBuf encode(ByteBufAllocator allocator, WellKnownMimeType mimeType) {
        return allocator.buffer(1, 1).writeByte(mimeType.getIdentifier() | 0x80);
    }

    public static ByteBuf encode(ByteBufAllocator allocator, String mimeType) {
        if (mimeType == null || mimeType.length() == 0) {
            throw new IllegalArgumentException("MIME type is required");
        }
        WellKnownMimeType wkn = WellKnownMimeType.fromString(mimeType);
        if (wkn == WellKnownMimeType.UNPARSEABLE_MIME_TYPE) {
            return MimeTypeMetadataCodec.encodeCustomMimeType(allocator, mimeType);
        }
        return MimeTypeMetadataCodec.encode(allocator, wkn);
    }

    public static ByteBuf encode(ByteBufAllocator allocator, List<String> mimeTypes) {
        if (mimeTypes == null || mimeTypes.size() == 0) {
            throw new IllegalArgumentException("No MIME types provided");
        }
        CompositeByteBuf compositeByteBuf = allocator.compositeBuffer();
        for (String mimeType : mimeTypes) {
            ByteBuf byteBuf = MimeTypeMetadataCodec.encode(allocator, mimeType);
            compositeByteBuf.addComponents(true, new ByteBuf[]{byteBuf});
        }
        return compositeByteBuf;
    }

    private static ByteBuf encodeCustomMimeType(ByteBufAllocator allocator, String customMimeType) {
        ByteBuf byteBuf = allocator.buffer(1 + customMimeType.length());
        byteBuf.writerIndex(1);
        int length = ByteBufUtil.writeUtf8((ByteBuf)byteBuf, (CharSequence)customMimeType);
        if (!ByteBufUtil.isText((ByteBuf)byteBuf, (int)1, (int)length, (Charset)CharsetUtil.US_ASCII)) {
            byteBuf.release();
            throw new IllegalArgumentException("MIME type must be ASCII characters only");
        }
        if (length < 1 || length > 128) {
            byteBuf.release();
            throw new IllegalArgumentException("MIME type must have a strictly positive length that fits on 7 unsigned bits, ie 1-128");
        }
        byteBuf.markWriterIndex();
        byteBuf.writerIndex(0);
        byteBuf.writeByte(length - 1);
        byteBuf.resetWriterIndex();
        return byteBuf;
    }

    public static List<String> decode(ByteBuf byteBuf) {
        ArrayList<String> mimeTypes = new ArrayList<String>();
        while (byteBuf.isReadable()) {
            byte idOrLength = byteBuf.readByte();
            if ((idOrLength & 0x80) == 128) {
                byte id = (byte)(idOrLength & 0x7F);
                WellKnownMimeType wellKnownMimeType = WellKnownMimeType.fromIdentifier(id);
                mimeTypes.add(wellKnownMimeType.toString());
                continue;
            }
            int length = Byte.toUnsignedInt(idOrLength) + 1;
            mimeTypes.add(byteBuf.readCharSequence(length, CharsetUtil.US_ASCII).toString());
        }
        return mimeTypes;
    }
}

