/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server;

import io.selendroid.server.BaseRequestHandler;
import io.selendroid.server.SelendroidResponse;
import io.selendroid.server.http.HttpRequest;
import io.selendroid.server.http.HttpResponse;
import io.selendroid.server.http.HttpServlet;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseServlet
implements HttpServlet {
    public static final String SESSION_ID_KEY = "SESSION_ID_KEY";
    public static final String ELEMENT_ID_KEY = "ELEMENT_ID_KEY";
    public static final String COMMAND_NAME_KEY = "COMMAND_KEY";
    public static final String NAME_ID_KEY = "NAME_ID_KEY";
    public static final String DRIVER_KEY = "DRIVER_KEY";
    public static final int INTERNAL_SERVER_ERROR = 500;
    protected Map<String, BaseRequestHandler> getHandler = new HashMap<String, BaseRequestHandler>();
    protected Map<String, BaseRequestHandler> postHandler = new HashMap<String, BaseRequestHandler>();
    protected Map<String, BaseRequestHandler> deleteHandler = new HashMap<String, BaseRequestHandler>();
    private Map<String, String[]> mapperUrlSectionsCache = new HashMap<String, String[]>();

    protected BaseRequestHandler findMatcher(HttpRequest request, Map<String, BaseRequestHandler> handler) {
        String[] urlToMatchSections = this.getRequestUrlSections(request.uri());
        for (Map.Entry<String, BaseRequestHandler> entry : handler.entrySet()) {
            String[] mapperUrlSections = this.getMapperUrlSectionsCached(entry.getKey());
            if (!this.isFor(mapperUrlSections, urlToMatchSections)) continue;
            return entry.getValue();
        }
        return null;
    }

    protected abstract void init();

    @Override
    public void handleHttpRequest(HttpRequest request, HttpResponse response) throws Exception {
        BaseRequestHandler handler = null;
        if ("GET".equals(request.method())) {
            handler = this.findMatcher(request, this.getHandler);
        } else if ("POST".equals(request.method())) {
            handler = this.findMatcher(request, this.postHandler);
        } else if ("DELETE".equals(request.method())) {
            handler = this.findMatcher(request, this.deleteHandler);
        }
        this.handleRequest(request, response, handler);
    }

    protected void register(Map<String, BaseRequestHandler> registerOn, BaseRequestHandler handler) {
        registerOn.put(handler.getMappedUri(), handler);
    }

    public abstract void handleRequest(HttpRequest var1, HttpResponse var2, BaseRequestHandler var3);

    protected String getParameter(String configuredUri, String actualUri, String param) {
        return this.getParameter(configuredUri, actualUri, param, true);
    }

    protected String getParameter(String configuredUri, String actualUri, String param, boolean sectionLengthValidation) {
        String[] configuredSections = configuredUri.split("/");
        String[] currentSections = actualUri.split("/");
        if (sectionLengthValidation && configuredSections.length != currentSections.length) {
            return null;
        }
        for (int i = 0; i < currentSections.length; ++i) {
            if (!configuredSections[i].contains(param)) continue;
            return currentSections[i];
        }
        return null;
    }

    protected void replyWithServerError(HttpResponse response) {
        System.out.println("replyWithServerError 500");
        response.setStatus(500);
        response.end();
    }

    protected boolean isFor(String[] mapperUrlSections, String[] urlToMatchSections) {
        if (urlToMatchSections == null) {
            return mapperUrlSections.length == 0;
        }
        if (mapperUrlSections.length != urlToMatchSections.length) {
            return false;
        }
        for (int i = 0; i < mapperUrlSections.length; ++i) {
            if (mapperUrlSections[i].startsWith(":") || mapperUrlSections[i].equals(urlToMatchSections[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isNewSessionRequest(HttpRequest request) {
        return "POST".equals(request.method()) && "/wd/hub/session".equals(request.uri());
    }

    protected void handleResponse(HttpRequest request, HttpResponse response, SelendroidResponse result) {
        response.setContentType("application/json");
        response.setEncoding(Charset.forName("UTF-8"));
        if (result != null) {
            String resultString = result.render();
            response.setContent(resultString);
        }
        if (this.isNewSessionRequest(request) && result.getStatus() == 0) {
            String session = result.getSessionId();
            String newSessionUri = "http://" + request.header("Host") + request.uri() + "/" + session;
            System.out.println("new Session URL: " + newSessionUri);
            response.sendRedirect(newSessionUri);
        } else {
            response.setStatus(200);
        }
        response.end();
    }

    private String[] getRequestUrlSections(String urlToMatch) {
        if (urlToMatch == null) {
            return null;
        }
        int qPos = urlToMatch.indexOf(63);
        if (qPos != -1) {
            urlToMatch = urlToMatch.substring(0, urlToMatch.indexOf("?"));
        }
        return urlToMatch.split("/");
    }

    private String[] getMapperUrlSectionsCached(String mapperUrl) {
        String[] sections = this.mapperUrlSectionsCache.get(mapperUrl);
        if (sections == null) {
            sections = mapperUrl.split("/");
            for (int i = 0; i < sections.length; ++i) {
                String section = sections[i];
                int qPos = section.indexOf(63);
                if (qPos == -1) continue;
                sections[i] = section.substring(0, qPos);
            }
            this.mapperUrlSectionsCache.put(mapperUrl, sections);
        }
        return sections;
    }
}

