/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.selendroid.server.http.HttpServlet;
import io.selendroid.server.http.ServerInitializer;
import java.util.ArrayList;
import java.util.List;

public class HttpServer {
    private final int port;
    private Thread serverThread;
    private final List<HttpServlet> handlers = new ArrayList<HttpServlet>();

    public HttpServer(int port) {
        this.port = port;
    }

    public void addHandler(HttpServlet handler) {
        this.handlers.add(handler);
    }

    public void start() {
        if (this.serverThread != null) {
            throw new IllegalStateException("Server is already running");
        }
        this.serverThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
                NioEventLoopGroup workerGroup = new NioEventLoopGroup();
                try {
                    ServerBootstrap bootstrap = new ServerBootstrap();
                    bootstrap.option(ChannelOption.SO_BACKLOG, (Object)1024);
                    ((ServerBootstrap)bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ServerInitializer(HttpServer.this.handlers));
                    Channel ch = bootstrap.bind(HttpServer.this.port).sync().channel();
                    ch.closeFuture().sync();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    bossGroup.shutdownGracefully();
                    workerGroup.shutdownGracefully();
                }
            }
        };
        this.serverThread.start();
    }

    public void stop() {
        if (this.serverThread == null) {
            throw new IllegalStateException("Server is not running");
        }
        this.serverThread.interrupt();
    }

    public int getPort() {
        return this.port;
    }
}

