/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server.http;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import io.selendroid.server.http.HttpServlet;
import io.selendroid.server.http.impl.NettyHttpRequest;
import io.selendroid.server.http.impl.NettyHttpResponse;
import java.util.List;

public class ServerHandler
extends ChannelInboundHandlerAdapter {
    private List<HttpServlet> httpHandlers;

    public ServerHandler(List<HttpServlet> handlers) {
        this.httpHandlers = handlers;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof FullHttpRequest)) {
            return;
        }
        FullHttpRequest request = (FullHttpRequest)msg;
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        NettyHttpRequest httpRequest = new NettyHttpRequest(request);
        NettyHttpResponse httpResponse = new NettyHttpResponse((FullHttpResponse)response);
        for (HttpServlet handler : this.httpHandlers) {
            handler.handleHttpRequest(httpRequest, httpResponse);
            if (!httpResponse.isClosed()) continue;
            break;
        }
        if (!httpResponse.isClosed()) {
            httpResponse.setStatus(404);
            httpResponse.end();
        }
        ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }
}

