/*
 * Decompiled with CFR 0.152.
 */
package io.selendroid.server.http.impl;

import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.CharsetUtil;
import io.selendroid.server.http.HttpResponse;
import java.nio.charset.Charset;

public class NettyHttpResponse
implements HttpResponse {
    private final FullHttpResponse response;
    private boolean closed = false;
    private Charset charset = CharsetUtil.UTF_8;

    public NettyHttpResponse(FullHttpResponse response) {
        this.response = response;
        response.headers().add("Content-Encoding", (Object)"identity");
    }

    @Override
    public HttpResponse setStatus(int status) {
        this.response.setStatus(HttpResponseStatus.valueOf((int)status));
        return this;
    }

    @Override
    public HttpResponse setContentType(String mimeType) {
        this.response.headers().add("Content-Type", (Object)mimeType);
        return this;
    }

    @Override
    public HttpResponse setContent(byte[] data) {
        this.response.headers().add("Content-Length", (Object)data.length);
        this.response.content().writeBytes(data);
        return this;
    }

    @Override
    public HttpResponse setContent(String message) {
        this.setContent(message.getBytes(this.charset));
        return this;
    }

    @Override
    public HttpResponse sendRedirect(String to) {
        this.setStatus(301);
        this.response.headers().add("location", (Object)to);
        return this;
    }

    @Override
    public HttpResponse sendTemporaryRedirect(String to) {
        this.setStatus(302);
        this.response.headers().add("location", (Object)to);
        return this;
    }

    @Override
    public void end() {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public HttpResponse setEncoding(Charset charset) {
        this.charset = charset;
        return this;
    }
}

