/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.autoinstall;

import io.sentry.autoinstall.util.SdkVersionInfo;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.eclipse.aether.artifact.Artifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryInstaller {
    @NotNull
    private final Logger logger;

    public SentryInstaller() {
        this(LoggerFactory.getLogger(SentryInstaller.class));
    }

    public SentryInstaller(@NotNull Logger logger) {
        this.logger = logger;
    }

    @Nullable
    public String install(@NotNull List<Dependency> dependencyList, @NotNull List<Artifact> resolvedArtifacts) {
        @Nullable Artifact sentryDependency = resolvedArtifacts.stream().filter(dep -> dep.getGroupId().equals("io.sentry") && dep.getArtifactId().equals("sentry")).findFirst().orElse(null);
        if (sentryDependency != null) {
            this.logger.info("Sentry already installed " + sentryDependency.getVersion());
            return sentryDependency.getVersion();
        }
        @Nullable String sentryVersion = SdkVersionInfo.getSentryVersion();
        if (sentryVersion == null) {
            this.logger.error("Unable to load sentry version, Sentry SDK cannot be auto-installed");
            return null;
        }
        this.logger.info("Installing Sentry with version " + sentryVersion);
        @NotNull Dependency newDep = new Dependency();
        newDep.setGroupId("io.sentry");
        newDep.setArtifactId("sentry");
        newDep.setVersion(sentryVersion);
        dependencyList.add(newDep);
        return sentryVersion;
    }
}

