/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.autoinstall.jdbc;

import io.sentry.autoinstall.AbstractIntegrationInstaller;
import io.sentry.autoinstall.AutoInstallState;
import io.sentry.semver.Version;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcInstallStrategy
extends AbstractIntegrationInstaller {
    @NotNull
    private static final String SPRING_JDBC_GROUP = "org.springframework";
    @NotNull
    private static final String SPRING_JDBC_ID = "spring-jdbc";
    @NotNull
    private static final String HSQL_GROUP = "org.hsqldb";
    @NotNull
    private static final String HSQL_ID = "hsqldb";
    @NotNull
    private static final String MYSQL_GROUP = "mysql";
    @NotNull
    private static final String MYSQL_ID = "mysql-connector-java";
    @NotNull
    private static final String MARIADB_GROUP = "org.mariadb.jdbc";
    @NotNull
    private static final String MARIADB_ID = "mariadb-java-client";
    @NotNull
    private static final String POSTGRES_GROUP = "org.postgresql";
    @NotNull
    private static final String POSTGRES_ID = "postgresql";
    @NotNull
    private static final String ORACLE_GROUP = "com.oracle.jdbc";
    @NotNull
    private static final String ORACLE_DATABASE_GROUP = "com.oracle.database.jdbc";
    @NotNull
    private static final String ORACLE_OJDBC_ID_PREFIX = "ojdbc";
    @NotNull
    public static final String SENTRY_JDBC_ID = "sentry-jdbc";

    public JdbcInstallStrategy() {
        this(LoggerFactory.getLogger(JdbcInstallStrategy.class));
    }

    public JdbcInstallStrategy(@NotNull Logger logger) {
        super(logger);
    }

    @Override
    @NotNull
    protected Version minSupportedSentryVersion() {
        return Version.create(5, 3, 0);
    }

    @Override
    @Nullable
    protected Artifact findThirdPartyDependency(@NotNull List<Artifact> resolvedArtifacts) {
        @NotNull ArrayList<String> oracleDependencyList = new ArrayList<String>();
        for (int i = 5; i <= 15; ++i) {
            oracleDependencyList.add("com.oracle.jdbc:ojdbc" + i);
            oracleDependencyList.add("com.oracle.database.jdbc:ojdbc" + i);
        }
        return resolvedArtifacts.stream().filter(dep -> dep.getGroupId().equals(SPRING_JDBC_GROUP) && dep.getArtifactId().equals(SPRING_JDBC_ID) || dep.getGroupId().equals(HSQL_GROUP) && dep.getArtifactId().equals(HSQL_ID) || dep.getGroupId().equals(MYSQL_GROUP) && dep.getArtifactId().equals(MYSQL_ID) || dep.getGroupId().equals(MARIADB_GROUP) && dep.getArtifactId().equals(MARIADB_ID) || dep.getGroupId().equals(SPRING_JDBC_GROUP) && dep.getArtifactId().equals(SPRING_JDBC_ID) || dep.getGroupId().equals(POSTGRES_GROUP) && dep.getArtifactId().equals(POSTGRES_ID) || oracleDependencyList.contains(dep.getGroupId() + ":" + dep.getArtifactId())).findFirst().orElse(null);
    }

    @Override
    protected boolean shouldInstallModule(@NotNull AutoInstallState autoInstallState) {
        return autoInstallState.isInstallJdbc();
    }

    @Override
    @NotNull
    protected String sentryModuleId() {
        return SENTRY_JDBC_ID;
    }
}

