/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.SiddhiAppRuntime;
import org.wso2.siddhi.core.config.SiddhiContext;
import org.wso2.siddhi.core.config.StatisticsConfiguration;
import org.wso2.siddhi.core.exception.CannotRestoreSiddhiAppStateException;
import org.wso2.siddhi.core.stream.input.source.SourceHandlerManager;
import org.wso2.siddhi.core.stream.output.sink.SinkHandlerManager;
import org.wso2.siddhi.core.table.record.RecordTableHandlerManager;
import org.wso2.siddhi.core.util.SiddhiAppRuntimeBuilder;
import org.wso2.siddhi.core.util.config.ConfigManager;
import org.wso2.siddhi.core.util.parser.SiddhiAppParser;
import org.wso2.siddhi.core.util.persistence.IncrementalPersistenceStore;
import org.wso2.siddhi.core.util.persistence.PersistenceStore;
import org.wso2.siddhi.query.api.SiddhiApp;
import org.wso2.siddhi.query.compiler.SiddhiCompiler;

public class SiddhiManager {
    private static final Logger log = Logger.getLogger(SiddhiManager.class);
    private SiddhiContext siddhiContext;
    private ConcurrentMap<String, SiddhiAppRuntime> siddhiAppRuntimeMap = new ConcurrentHashMap<String, SiddhiAppRuntime>();

    public SiddhiManager() {
        this.siddhiContext = new SiddhiContext();
    }

    public SiddhiAppRuntime createSiddhiAppRuntime(SiddhiApp siddhiApp) {
        return this.createSiddhiAppRuntime(siddhiApp, null);
    }

    private SiddhiAppRuntime createSiddhiAppRuntime(SiddhiApp siddhiApp, String siddhiAppString) {
        SiddhiAppRuntimeBuilder siddhiAppRuntimeBuilder = SiddhiAppParser.parse(siddhiApp, siddhiAppString, this.siddhiContext);
        siddhiAppRuntimeBuilder.setSiddhiAppRuntimeMap(this.siddhiAppRuntimeMap);
        SiddhiAppRuntime siddhiAppRuntime = siddhiAppRuntimeBuilder.build();
        this.siddhiAppRuntimeMap.put(siddhiAppRuntime.getName(), siddhiAppRuntime);
        return siddhiAppRuntime;
    }

    public SiddhiAppRuntime createSiddhiAppRuntime(String siddhiApp) {
        return this.createSiddhiAppRuntime(SiddhiCompiler.parse((String)siddhiApp), siddhiApp);
    }

    public SiddhiAppRuntime getSiddhiAppRuntime(String siddhiAppName) {
        return (SiddhiAppRuntime)this.siddhiAppRuntimeMap.get(siddhiAppName);
    }

    public void validateSiddhiApp(SiddhiApp siddhiApp) {
        this.validateSiddhiApp(siddhiApp, null);
    }

    private void validateSiddhiApp(SiddhiApp siddhiApp, String siddhiAppString) {
        SiddhiAppRuntime siddhiAppRuntime = SiddhiAppParser.parse(siddhiApp, siddhiAppString, this.siddhiContext).build();
        siddhiAppRuntime.start();
        siddhiAppRuntime.shutdown();
    }

    public void validateSiddhiApp(String siddhiApp) {
        this.validateSiddhiApp(SiddhiCompiler.parse((String)siddhiApp), siddhiApp);
    }

    public void setPersistenceStore(PersistenceStore persistenceStore) {
        this.siddhiContext.setPersistenceStore(persistenceStore);
    }

    public void setSinkHandlerManager(SinkHandlerManager sinkHandlerManager) {
        this.siddhiContext.setSinkHandlerManager(sinkHandlerManager);
    }

    public void setSourceHandlerManager(SourceHandlerManager sourceHandlerManager) {
        this.siddhiContext.setSourceHandlerManager(sourceHandlerManager);
    }

    public void setRecordTableHandlerManager(RecordTableHandlerManager recordTableHandlerManager) {
        this.siddhiContext.setRecordTableHandlerManager(recordTableHandlerManager);
    }

    public void setConfigManager(ConfigManager configManager) {
        this.siddhiContext.setConfigManager(configManager);
    }

    public void setExtension(String name, Class clazz) {
        this.siddhiContext.getSiddhiExtensions().put(name, clazz);
    }

    public Map<String, Class> getExtensions() {
        return this.siddhiContext.getSiddhiExtensions();
    }

    public void removeExtension(String name) {
        this.siddhiContext.getSiddhiExtensions().remove(name);
    }

    public void setDataSource(String dataSourceName, DataSource dataSource) {
        this.siddhiContext.addSiddhiDataSource(dataSourceName, dataSource);
    }

    public void setStatisticsConfiguration(StatisticsConfiguration statisticsConfiguration) {
        this.siddhiContext.setStatisticsConfiguration(statisticsConfiguration);
    }

    public ConcurrentMap<String, SiddhiAppRuntime> getSiddhiAppRuntimeMap() {
        return this.siddhiAppRuntimeMap;
    }

    public void shutdown() {
        ArrayList siddhiAppNames = new ArrayList(this.siddhiAppRuntimeMap.keySet());
        for (String siddhiAppName : siddhiAppNames) {
            ((SiddhiAppRuntime)this.siddhiAppRuntimeMap.get(siddhiAppName)).shutdown();
        }
    }

    public void persist() {
        for (SiddhiAppRuntime siddhiAppRuntime : this.siddhiAppRuntimeMap.values()) {
            siddhiAppRuntime.persist();
        }
    }

    public void restoreLastState() {
        for (SiddhiAppRuntime siddhiAppRuntime : this.siddhiAppRuntimeMap.values()) {
            try {
                siddhiAppRuntime.restoreLastRevision();
            }
            catch (CannotRestoreSiddhiAppStateException e) {
                log.error((Object)("Error in restoring Siddhi app " + siddhiAppRuntime.getName()), (Throwable)e);
            }
        }
    }

    public String getLastRevision(String siddhiAppName) {
        return this.siddhiContext.getPersistenceStore().getLastRevision(siddhiAppName);
    }

    public void setIncrementalPersistenceStore(IncrementalPersistenceStore incrementalPersistenceStore) {
        this.siddhiContext.setIncrementalPersistenceStore(incrementalPersistenceStore);
    }
}

