/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.event.stream;

import java.io.Serializable;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventFactory;

public class StreamEventPool
implements Serializable {
    private static final long serialVersionUID = -1743558131917334571L;
    private StreamEventFactory eventFactory;
    private int size;
    private int index = 0;
    private StreamEvent streamEventList;

    public StreamEventPool(MetaStreamEvent metaStreamEvent, int size) {
        this.eventFactory = new StreamEventFactory(metaStreamEvent.getBeforeWindowData().size(), metaStreamEvent.getOnAfterWindowData().size(), metaStreamEvent.getOutputData().size());
        this.size = size;
    }

    public StreamEventPool(int beforeWindowDataSize, int onAfterWindowDataSize, int outputDataSize, int poolSize) {
        this.eventFactory = new StreamEventFactory(beforeWindowDataSize, onAfterWindowDataSize, outputDataSize);
        this.size = poolSize;
    }

    public StreamEvent borrowEvent() {
        if (this.index > 0) {
            StreamEvent event = this.streamEventList;
            this.streamEventList = this.streamEventList.getNext();
            event.setNext(null);
            --this.index;
            return event;
        }
        return this.eventFactory.newInstance();
    }

    public void returnEvents(StreamEvent streamEvent) {
        if (streamEvent != null && this.index < this.size) {
            StreamEvent first = streamEvent;
            StreamEvent last = streamEvent;
            while (streamEvent != null) {
                last = streamEvent;
                ++this.index;
                streamEvent = streamEvent.getNext();
            }
            last.setNext(this.streamEventList);
            this.streamEventList = first;
        }
    }

    public int getBufferedEventsSize() {
        return this.index;
    }

    public int getSize() {
        return this.size;
    }
}

