/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.executor.function;

import java.util.HashSet;
import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="createSet", namespace="", description="Includes the given input parameter in a java.util.HashSet and returns the set. ", parameters={@Parameter(name="input", description="The input that needs to be added into the set.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING, DataType.BOOL})}, returnAttributes={@ReturnAttribute(description="The set that includes the input element.", type={DataType.OBJECT})}, examples={@Example(syntax="from stockStream \nselect createSet(symbol) as initialSet \ninsert into initStream;", description="For every incoming stockStream event, the initStream stream will produce a set object having only one element: the symbol in the incoming stockStream.")})
public class CreateSetFunctionExecutor
extends FunctionExecutor {
    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("createSet() function has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        if (!this.isAttributeTypeSupported(attributeExpressionExecutors[0].getReturnType())) {
            throw new OperationNotSupportedException("createSet() function not supported for type: " + attributeExpressionExecutors[0].getReturnType());
        }
    }

    @Override
    protected Object execute(Object[] data) {
        return null;
    }

    @Override
    protected Object execute(Object data) {
        HashSet<Object> set = new HashSet<Object>();
        set.add(data);
        return set;
    }

    @Override
    public Attribute.Type getReturnType() {
        return Attribute.Type.OBJECT;
    }

    @Override
    public Map<String, Object> currentState() {
        return null;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
    }

    private boolean isAttributeTypeSupported(Attribute.Type type) {
        switch (type) {
            case FLOAT: {
                return true;
            }
            case INT: {
                return true;
            }
            case LONG: {
                return true;
            }
            case DOUBLE: {
                return true;
            }
            case STRING: {
                return true;
            }
            case BOOL: {
                return true;
            }
        }
        return false;
    }
}

