/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.executor.function;

import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="instanceOfInteger", namespace="", description="Checks whether the parameter is an instance of Integer or not.", parameters={@Parameter(name="arg", description="The parameter to be checked.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING, DataType.BOOL, DataType.OBJECT})}, returnAttributes={@ReturnAttribute(description="Returned type will be boolean and true if and only if the input is a instance of Integer.", type={DataType.BOOL})}, examples={@Example(syntax="from fooStream\nselect instanceOfInteger(value) as state\ninsert into barStream;", description="This will return true if the value field format is integer."), @Example(syntax="from fooStream\nselect instanceOfInteger(switchState) as state\ninsert into barStream;", description="if the switchState = true then this will returns false as the value is an instance of the boolean not a long.")})
public class InstanceOfIntegerFunctionExecutor
extends FunctionExecutor {
    Attribute.Type returnType = Attribute.Type.BOOL;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to instanceOfInteger() function, required only 1, but found " + attributeExpressionExecutors.length);
        }
    }

    @Override
    protected Object execute(Object[] data) {
        return null;
    }

    @Override
    protected Object execute(Object data) {
        return data instanceof Integer;
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Map<String, Object> currentState() {
        return null;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
    }
}

