/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.executor.function;

import java.util.Map;
import java.util.UUID;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;

@Extension(name="UUID", namespace="", description="Generates a UUID (Universally Unique Identifier).", parameters={}, returnAttributes={@ReturnAttribute(description="Returns a UUID string.", type={DataType.STRING})}, examples={@Example(syntax="from TempStream\nselect convert(roomNo, 'string') as roomNo, temp, UUID() as messageID\ninsert into RoomTempStream;", description="This will converts a room number to string, introducing a message ID to each event asUUID() returns a34eec40-32c2-44fe-8075-7f4fde2e2dd8\n\nfrom TempStream\nselect convert(roomNo, 'string') as roomNo, temp, UUID() as messageID\ninsert into RoomTempStream;")})
public class UUIDFunctionExecutor
extends FunctionExecutor {
    Attribute.Type returnType = Attribute.Type.STRING;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
    }

    @Override
    protected Object execute(Object[] data) {
        return null;
    }

    @Override
    protected Object execute(Object data) {
        return UUID.randomUUID().toString();
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Map<String, Object> currentState() {
        return null;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
    }
}

