/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query;

import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.query.StoreQueryRuntime;

public class UpdateStoreQueryRuntime
extends StoreQueryRuntime {
    public UpdateStoreQueryRuntime(String queryName, MetaStreamEvent metaStreamEvent) {
        this.queryName = queryName;
        this.eventType = metaStreamEvent.getEventType();
        this.metaStreamEvent = metaStreamEvent;
        this.setOutputAttributes(metaStreamEvent.getLastInputDefinition().getAttributeList());
    }

    @Override
    public void reset() {
        if (this.selector != null) {
            this.selector.process(this.generateResetComplexEventChunk(this.metaStreamEvent));
        }
    }

    @Override
    public StoreQueryRuntime.TYPE getType() {
        return StoreQueryRuntime.TYPE.UPDATE;
    }

    private ComplexEventChunk<ComplexEvent> generateResetComplexEventChunk(MetaStreamEvent metaStreamEvent) {
        StreamEvent streamEvent = new StreamEvent(metaStreamEvent.getBeforeWindowData().size(), metaStreamEvent.getOnAfterWindowData().size(), metaStreamEvent.getOutputData().size());
        streamEvent.setType(ComplexEvent.Type.RESET);
        StateEvent stateEvent = this.stateEventPool.borrowEvent();
        stateEvent.addEvent(0, streamEvent);
        stateEvent.setType(ComplexEvent.Type.RESET);
        ComplexEventChunk<ComplexEvent> complexEventChunk = new ComplexEventChunk<ComplexEvent>(true);
        complexEventChunk.add(stateEvent);
        return complexEventChunk;
    }
}

