/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.input;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.debugger.SiddhiDebugger;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.event.stream.converter.StreamEventConverter;
import org.wso2.siddhi.core.event.stream.converter.StreamEventConverterFactory;
import org.wso2.siddhi.core.query.input.stream.state.PreStateProcessor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.stream.StreamJunction;
import org.wso2.siddhi.core.util.lock.LockWrapper;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;

public class ProcessStreamReceiver
implements StreamJunction.Receiver {
    protected String streamId;
    protected Processor next;
    protected List<PreStateProcessor> stateProcessors = new ArrayList<PreStateProcessor>();
    protected int stateProcessorsSize;
    protected LatencyTracker latencyTracker;
    protected LockWrapper lockWrapper;
    protected boolean batchProcessingAllowed;
    protected SiddhiAppContext siddhiAppContext;
    private StreamEventConverter streamEventConverter;
    private MetaStreamEvent metaStreamEvent;
    private StreamEventPool streamEventPool;
    private SiddhiDebugger siddhiDebugger;
    private String queryName;

    public ProcessStreamReceiver(String streamId, LatencyTracker latencyTracker, String queryName, SiddhiAppContext siddhiAppContext) {
        this.streamId = streamId;
        this.latencyTracker = latencyTracker;
        this.queryName = queryName;
        this.siddhiAppContext = siddhiAppContext;
    }

    @Override
    public String getStreamId() {
        return this.streamId;
    }

    public ProcessStreamReceiver clone(String key) {
        ProcessStreamReceiver processStreamReceiver = new ProcessStreamReceiver(this.streamId + key, this.latencyTracker, this.queryName, this.siddhiAppContext);
        processStreamReceiver.batchProcessingAllowed = this.batchProcessingAllowed;
        return processStreamReceiver;
    }

    public void setSiddhiDebugger(SiddhiDebugger siddhiDebugger) {
        this.siddhiDebugger = siddhiDebugger;
    }

    private void process(ComplexEventChunk<StreamEvent> streamEventChunk) {
        block9: {
            if (this.lockWrapper != null) {
                this.lockWrapper.lock();
            }
            try {
                if (this.siddhiAppContext.isStatsEnabled() && this.latencyTracker != null) {
                    try {
                        this.latencyTracker.markIn();
                        this.processAndClear(streamEventChunk);
                        break block9;
                    }
                    finally {
                        this.latencyTracker.markOut();
                    }
                }
                this.processAndClear(streamEventChunk);
            }
            finally {
                if (this.lockWrapper != null) {
                    this.lockWrapper.unlock();
                }
            }
        }
    }

    @Override
    public void receive(ComplexEvent complexEvents) {
        if (this.siddhiDebugger != null) {
            this.siddhiDebugger.checkBreakPoint(this.queryName, SiddhiDebugger.QueryTerminal.IN, complexEvents);
        }
        StreamEvent firstEvent = this.streamEventPool.borrowEvent();
        this.streamEventConverter.convertComplexEvent(complexEvents, firstEvent);
        StreamEvent currentEvent = firstEvent;
        for (complexEvents = complexEvents.getNext(); complexEvents != null; complexEvents = complexEvents.getNext()) {
            StreamEvent nextEvent = this.streamEventPool.borrowEvent();
            this.streamEventConverter.convertComplexEvent(complexEvents, nextEvent);
            currentEvent.setNext(nextEvent);
            currentEvent = nextEvent;
        }
        this.process(new ComplexEventChunk<StreamEvent>(firstEvent, currentEvent, this.batchProcessingAllowed));
    }

    @Override
    public void receive(Event event) {
        if (event != null) {
            StreamEvent borrowedEvent = this.streamEventPool.borrowEvent();
            this.streamEventConverter.convertEvent(event, borrowedEvent);
            if (this.siddhiDebugger != null) {
                this.siddhiDebugger.checkBreakPoint(this.queryName, SiddhiDebugger.QueryTerminal.IN, borrowedEvent);
            }
            this.process(new ComplexEventChunk<StreamEvent>(borrowedEvent, borrowedEvent, this.batchProcessingAllowed));
        }
    }

    @Override
    public void receive(Event[] events) {
        StreamEvent firstEvent = this.streamEventPool.borrowEvent();
        this.streamEventConverter.convertEvent(events[0], firstEvent);
        StreamEvent currentEvent = firstEvent;
        int eventsLength = events.length;
        for (int i = 1; i < eventsLength; ++i) {
            StreamEvent nextEvent = this.streamEventPool.borrowEvent();
            this.streamEventConverter.convertEvent(events[i], nextEvent);
            currentEvent.setNext(nextEvent);
            currentEvent = nextEvent;
        }
        if (this.siddhiDebugger != null) {
            this.siddhiDebugger.checkBreakPoint(this.queryName, SiddhiDebugger.QueryTerminal.IN, firstEvent);
        }
        this.process(new ComplexEventChunk<StreamEvent>(firstEvent, currentEvent, this.batchProcessingAllowed));
    }

    @Override
    public void receive(List<Event> events) {
        StreamEvent firstEvent = null;
        StreamEvent currentEvent = null;
        for (Event event : events) {
            StreamEvent nextEvent = this.streamEventPool.borrowEvent();
            this.streamEventConverter.convertEvent(event, nextEvent);
            if (firstEvent == null) {
                firstEvent = nextEvent;
            } else {
                currentEvent.setNext(nextEvent);
            }
            currentEvent = nextEvent;
        }
        if (this.siddhiDebugger != null) {
            this.siddhiDebugger.checkBreakPoint(this.queryName, SiddhiDebugger.QueryTerminal.IN, firstEvent);
        }
        this.process(new ComplexEventChunk<Object>(firstEvent, currentEvent, this.batchProcessingAllowed));
    }

    @Override
    public void receive(long timestamp, Object[] data) {
        StreamEvent borrowedEvent = this.streamEventPool.borrowEvent();
        this.streamEventConverter.convertData(timestamp, data, borrowedEvent);
        if (this.siddhiDebugger != null) {
            this.siddhiDebugger.checkBreakPoint(this.queryName, SiddhiDebugger.QueryTerminal.IN, borrowedEvent);
        }
        this.process(new ComplexEventChunk<StreamEvent>(borrowedEvent, borrowedEvent, this.batchProcessingAllowed));
    }

    protected void processAndClear(ComplexEventChunk<StreamEvent> streamEventChunk) {
        this.next.process(streamEventChunk);
        streamEventChunk.clear();
    }

    public void setMetaStreamEvent(MetaStreamEvent metaStreamEvent) {
        this.metaStreamEvent = metaStreamEvent;
    }

    public boolean toStream() {
        return this.metaStreamEvent.getEventType() == MetaStreamEvent.EventType.DEFAULT || this.metaStreamEvent.getEventType() == MetaStreamEvent.EventType.WINDOW;
    }

    public void setBatchProcessingAllowed(boolean batchProcessingAllowed) {
        this.batchProcessingAllowed = batchProcessingAllowed;
    }

    public void setNext(Processor next) {
        this.next = next;
    }

    public void setStreamEventPool(StreamEventPool streamEventPool) {
        this.streamEventPool = streamEventPool;
    }

    public void setLockWrapper(LockWrapper lockWrapper) {
        this.lockWrapper = lockWrapper;
    }

    public void init() {
        this.streamEventConverter = StreamEventConverterFactory.constructEventConverter(this.metaStreamEvent);
    }

    public void addStatefulProcessor(PreStateProcessor stateProcessor) {
        this.stateProcessors.add(stateProcessor);
        this.stateProcessorsSize = this.stateProcessors.size();
    }
}

