/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.input.stream.state;

import java.util.Iterator;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.query.input.stream.state.CountPostStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.PreStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.StreamPreStateProcessor;
import org.wso2.siddhi.query.api.execution.query.input.stream.StateInputStream;

public class CountPreStateProcessor
extends StreamPreStateProcessor {
    private final int minCount;
    private final int maxCount;
    protected volatile boolean successCondition = false;
    private CountPostStateProcessor countPostStateProcessor;
    private volatile boolean startStateReset = false;

    public CountPreStateProcessor(int minCount, int maxCount, StateInputStream.Type stateType) {
        super(stateType);
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    @Override
    public PreStateProcessor cloneProcessor(String key) {
        CountPreStateProcessor countPreStateProcessor = new CountPreStateProcessor(this.minCount, this.maxCount, this.stateType);
        this.cloneProperties(countPreStateProcessor, key);
        countPreStateProcessor.init(this.siddhiAppContext, this.queryName);
        return countPreStateProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComplexEventChunk<StateEvent> processAndReturn(ComplexEventChunk complexEventChunk) {
        ComplexEventChunk<StateEvent> returnEventChunk = new ComplexEventChunk<StateEvent>(false);
        complexEventChunk.reset();
        StreamEvent streamEvent = (StreamEvent)complexEventChunk.next();
        this.lock.lock();
        try {
            Iterator<StateEvent> iterator = this.pendingStateEventList.iterator();
            while (iterator.hasNext()) {
                StateEvent stateEvent = (StateEvent)iterator.next();
                if (this.removeIfNextStateProcessed(stateEvent, iterator, this.stateId + 1) || this.removeIfNextStateProcessed(stateEvent, iterator, this.stateId + 2)) continue;
                stateEvent.addEvent(this.stateId, this.streamEventCloner.copyStreamEvent(streamEvent));
                this.successCondition = false;
                this.process(stateEvent);
                if (this.thisLastProcessor.isEventReturned()) {
                    this.thisLastProcessor.clearProcessedEvent();
                    returnEventChunk.add(stateEvent);
                }
                if (this.stateChanged) {
                    iterator.remove();
                }
                if (this.successCondition) continue;
                switch (this.stateType) {
                    case PATTERN: {
                        stateEvent.removeLastEvent(this.stateId);
                        break;
                    }
                    case SEQUENCE: {
                        stateEvent.removeLastEvent(this.stateId);
                        iterator.remove();
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return returnEventChunk;
    }

    private boolean removeIfNextStateProcessed(StateEvent stateEvent, Iterator<StateEvent> iterator, int position) {
        if (stateEvent.getStreamEvents().length > position && stateEvent.getStreamEvent(position) != null) {
            iterator.remove();
            return true;
        }
        return false;
    }

    public void successCondition() {
        this.successCondition = true;
    }

    @Override
    public void addState(StateEvent stateEvent) {
        this.lock.lock();
        try {
            if (this.stateType == StateInputStream.Type.SEQUENCE) {
                if (this.newAndEveryStateEventList.isEmpty()) {
                    this.newAndEveryStateEventList.add(stateEvent);
                }
            } else {
                this.newAndEveryStateEventList.add(stateEvent);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.minCount == 0 && stateEvent.getStreamEvent(this.stateId) == null) {
            this.currentStateEventChunk.clear();
            this.currentStateEventChunk.add(stateEvent);
            this.countPostStateProcessor.processMinCountReached(stateEvent, this.currentStateEventChunk);
            this.currentStateEventChunk.clear();
        }
    }

    public CountPostStateProcessor getCountPostStateProcessor() {
        return this.countPostStateProcessor;
    }

    public void setCountPostStateProcessor(CountPostStateProcessor countPostStateProcessor) {
        this.countPostStateProcessor = countPostStateProcessor;
    }

    public void startStateReset() {
        this.startStateReset = true;
        if (this.thisStatePostProcessor.callbackPreStateProcessor != null) {
            ((CountPreStateProcessor)this.countPostStateProcessor.thisStatePreProcessor).startStateReset();
        }
    }

    @Override
    public void updateState() {
        if (this.startStateReset) {
            this.startStateReset = false;
            this.init();
        }
        super.updateState();
    }
}

