/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.processor.stream.window;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.window.FindableProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.WindowProcessor;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.parser.OperatorParser;
import org.wso2.siddhi.query.api.expression.Expression;

@Extension(name="frequent", namespace="", description="This window returns the latest events with the most frequently occurred value for a given attribute(s). Frequency calculation for this window processor is based on Misra-Gries counting algorithm.", parameters={@Parameter(name="event.count", description="The number of most frequent events to be emitted to the stream.", type={DataType.INT}), @Parameter(name="attribute", description="The attributes to group the events. If no attributes are given, the concatenation of all the attributes of the event is considered.", type={DataType.STRING}, optional=true, defaultValue="The concatenation of all the attributes of the event is considered.")}, examples={@Example(syntax="@info(name = 'query1')\nfrom purchase[price >= 30]#window.frequent(2)\nselect cardNo, price\ninsert all events into PotentialFraud;", description="This will returns the 2 most frequent events."), @Example(syntax="@info(name = 'query1')\nfrom purchase[price >= 30]#window.frequent(2, cardNo)\nselect cardNo, price\ninsert all events into PotentialFraud;", description="This will returns the 2 latest events with the most frequently appeared card numbers.")})
public class FrequentWindowProcessor
extends WindowProcessor
implements FindableProcessor {
    private ConcurrentHashMap<String, Integer> countMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, StreamEvent> map = new ConcurrentHashMap();
    private VariableExpressionExecutor[] variableExpressionExecutors;
    private int mostFrequentCount;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, boolean outputExpectsExpiredEvents, SiddhiAppContext siddhiAppContext) {
        this.mostFrequentCount = Integer.parseInt(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue()));
        this.variableExpressionExecutors = new VariableExpressionExecutor[attributeExpressionExecutors.length - 1];
        for (int i = 1; i < attributeExpressionExecutors.length; ++i) {
            this.variableExpressionExecutors[i - 1] = (VariableExpressionExecutor)attributeExpressionExecutors[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner) {
        FrequentWindowProcessor frequentWindowProcessor = this;
        synchronized (frequentWindowProcessor) {
            StreamEvent streamEvent = streamEventChunk.getFirst();
            streamEventChunk.clear();
            long currentTime = this.siddhiAppContext.getTimestampGenerator().currentTime();
            while (streamEvent != null) {
                StreamEvent next = streamEvent.getNext();
                streamEvent.setNext(null);
                StreamEvent clonedEvent = streamEventCloner.copyStreamEvent(streamEvent);
                clonedEvent.setType(ComplexEvent.Type.EXPIRED);
                String key = this.generateKey(streamEvent);
                StreamEvent oldEvent = this.map.put(key, clonedEvent);
                if (oldEvent != null) {
                    this.countMap.put(key, this.countMap.get(key) + 1);
                    streamEventChunk.add(streamEvent);
                } else if (this.map.size() > this.mostFrequentCount) {
                    ArrayList keys = new ArrayList(this.countMap.keySet());
                    for (int i = 0; i < this.mostFrequentCount; ++i) {
                        int count = this.countMap.get(keys.get(i)) - 1;
                        if (count == 0) {
                            this.countMap.remove(keys.get(i));
                            StreamEvent expiredEvent = this.map.remove(keys.get(i));
                            expiredEvent.setTimestamp(currentTime);
                            streamEventChunk.add(expiredEvent);
                            continue;
                        }
                        this.countMap.put((String)keys.get(i), count);
                    }
                    if (this.map.size() > this.mostFrequentCount) {
                        this.map.remove(key);
                    } else {
                        this.countMap.put(key, 1);
                        streamEventChunk.add(streamEvent);
                    }
                } else {
                    this.countMap.put(this.generateKey(streamEvent), 1);
                    streamEventChunk.add(streamEvent);
                }
                streamEvent = next;
            }
        }
        nextProcessor.process(streamEventChunk);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        FrequentWindowProcessor frequentWindowProcessor = this;
        synchronized (frequentWindowProcessor) {
            state.put("CountMap", this.countMap);
        }
        return state;
    }

    @Override
    public synchronized void restoreState(Map<String, Object> state) {
        this.countMap = (ConcurrentHashMap)state.get("CountMap");
    }

    private String generateKey(StreamEvent event) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.variableExpressionExecutors.length == 0) {
            for (Object data : event.getOutputData()) {
                stringBuilder.append(data);
            }
        } else {
            for (VariableExpressionExecutor executor : this.variableExpressionExecutors) {
                stringBuilder.append(event.getAttribute(executor.getPosition()));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public synchronized StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition) {
        return ((Operator)compiledCondition).find(matchingEvent, this.map.values(), this.streamEventCloner);
    }

    @Override
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, SiddhiAppContext siddhiAppContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, String queryName) {
        return OperatorParser.constructOperator(this.map.values(), condition, matchingMetaInfoHolder, siddhiAppContext, variableExpressionExecutors, tableMap, this.queryName);
    }
}

