/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.processor.stream.window;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.SchedulingProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.FindableProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.WindowProcessor;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.parser.OperatorParser;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;
import org.wso2.siddhi.query.api.expression.Expression;

@Extension(name="timeLength", namespace="", description="A sliding time window that, at a given time holds the last window.length events that arrived during last window.time period, and gets updated for every event arrival and expiry.", parameters={@Parameter(name="window.time", description="The sliding time period for which the window should hold events.", type={DataType.INT, DataType.LONG, DataType.TIME}), @Parameter(name="window.length", description="The number of events that should be be included in a sliding length window..", type={DataType.INT})}, examples={@Example(syntax="define stream cseEventStream (symbol string, price float, volume int);\ndefine window cseEventWindow (symbol string, price float, volume int) timeLength(2 sec, 10);\n@info(name = 'query0')\nfrom cseEventStream\ninsert into cseEventWindow;\n@info(name = 'query1')\nfrom cseEventWindow select symbol, price, volume\ninsert all events into outputStream;", description="window.timeLength(2 sec, 10) holds the last 10 events that arrived during last 2 seconds and gets updated for every event arrival and expiry.")})
public class TimeLengthWindowProcessor
extends WindowProcessor
implements SchedulingProcessor,
FindableProcessor {
    private long timeInMilliSeconds;
    private int length;
    private int count = 0;
    private ComplexEventChunk<StreamEvent> expiredEventChunk;
    private Scheduler scheduler;
    private SiddhiAppContext siddhiAppContext;

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, boolean outputExpectsExpiredEvents, SiddhiAppContext siddhiAppContext) {
        this.siddhiAppContext = siddhiAppContext;
        this.expiredEventChunk = new ComplexEventChunk(false);
        if (attributeExpressionExecutors.length != 2) throw new SiddhiAppValidationException("TimeLength window should only have two parameters (<int> windowTime,<int> windowLength), but found " + attributeExpressionExecutors.length + " input attributes");
        this.length = (Integer)((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue();
        if (!(attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor)) throw new SiddhiAppValidationException("TimeLength window should have constant parameter attributes but found a dynamic attribute " + attributeExpressionExecutors[0].getClass().getCanonicalName());
        if (attributeExpressionExecutors[0].getReturnType() == Attribute.Type.INT) {
            this.timeInMilliSeconds = ((Integer)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue()).intValue();
            return;
        } else {
            if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) throw new SiddhiAppValidationException("TimeLength window's first parameter attribute should be either int or long, but found " + attributeExpressionExecutors[0].getReturnType());
            this.timeInMilliSeconds = (Long)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner) {
        TimeLengthWindowProcessor timeLengthWindowProcessor = this;
        synchronized (timeLengthWindowProcessor) {
            long currentTime = this.siddhiAppContext.getTimestampGenerator().currentTime();
            while (streamEventChunk.hasNext()) {
                StreamEvent expiredEvent;
                long timeDiff;
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                this.expiredEventChunk.reset();
                while (this.expiredEventChunk.hasNext() && (timeDiff = (expiredEvent = (StreamEvent)this.expiredEventChunk.next()).getTimestamp() - currentTime + this.timeInMilliSeconds) <= 0L) {
                    this.expiredEventChunk.remove();
                    --this.count;
                    expiredEvent.setTimestamp(currentTime);
                    streamEventChunk.insertBeforeCurrent(expiredEvent);
                }
                this.expiredEventChunk.reset();
                if (streamEvent.getType() == ComplexEvent.Type.CURRENT) {
                    StreamEvent clonedEvent = streamEventCloner.copyStreamEvent(streamEvent);
                    clonedEvent.setType(ComplexEvent.Type.EXPIRED);
                    if (this.count < this.length) {
                        ++this.count;
                        this.expiredEventChunk.add(clonedEvent);
                    } else {
                        StreamEvent firstEvent = this.expiredEventChunk.poll();
                        if (firstEvent != null) {
                            firstEvent.setTimestamp(currentTime);
                            streamEventChunk.insertBeforeCurrent(firstEvent);
                            this.expiredEventChunk.add(clonedEvent);
                        }
                    }
                    this.scheduler.notifyAt(clonedEvent.getTimestamp() + this.timeInMilliSeconds);
                    continue;
                }
                streamEventChunk.remove();
            }
        }
        streamEventChunk.reset();
        if (streamEventChunk.hasNext()) {
            nextProcessor.process(streamEventChunk);
        }
    }

    @Override
    public synchronized StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition) {
        return ((Operator)compiledCondition).find(matchingEvent, this.expiredEventChunk, this.streamEventCloner);
    }

    @Override
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, SiddhiAppContext siddhiAppContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, String queryName) {
        return OperatorParser.constructOperator(this.expiredEventChunk, condition, matchingMetaInfoHolder, siddhiAppContext, variableExpressionExecutors, tableMap, this.queryName);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("ExpiredEventChunk", this.expiredEventChunk.getFirst());
        return state;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.expiredEventChunk.clear();
        this.expiredEventChunk.add((StreamEvent)state.get("ExpiredEventChunk"));
    }
}

