/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector;

import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.MetaComplexEvent;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.parser.ExpressionParser;
import org.wso2.siddhi.query.api.expression.Expression;

public class GroupByKeyGenerator {
    private ExpressionExecutor[] groupByExecutors = null;

    public GroupByKeyGenerator(List<Expression> groupByList, MetaComplexEvent metaComplexEvent, int currentState, Map<String, Table> tableMap, List<VariableExpressionExecutor> executors, SiddhiAppContext siddhiContext, String queryName) {
        if (!groupByList.isEmpty()) {
            this.groupByExecutors = new ExpressionExecutor[groupByList.size()];
            int expressionsSize = groupByList.size();
            for (int i = 0; i < expressionsSize; ++i) {
                this.groupByExecutors[i] = ExpressionParser.parseExpression(groupByList.get(i), metaComplexEvent, currentState, tableMap, executors, siddhiContext, false, 0, queryName);
            }
        }
    }

    public String constructEventKey(ComplexEvent event) {
        if (this.groupByExecutors != null) {
            StringBuilder sb = new StringBuilder();
            for (ExpressionExecutor executor : this.groupByExecutors) {
                sb.append(executor.execute(event)).append(":-:");
            }
            return sb.toString();
        }
        return null;
    }

    public void clean() {
        for (ExpressionExecutor expressionExecutor : this.groupByExecutors) {
            expressionExecutor.clean();
        }
    }
}

