/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.stream.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.StreamJunction;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;

public abstract class StreamCallback
implements StreamJunction.Receiver {
    private static final Logger log = Logger.getLogger(StreamCallback.class);
    private String streamId;
    private AbstractDefinition streamDefinition;
    private SiddhiAppContext siddhiAppContext;

    @Override
    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public AbstractDefinition getStreamDefinition() {
        return this.streamDefinition;
    }

    public void setStreamDefinition(AbstractDefinition streamDefinition) {
        this.streamDefinition = streamDefinition;
    }

    public void setContext(SiddhiAppContext siddhiAppContext) {
        this.siddhiAppContext = siddhiAppContext;
    }

    public Map<String, Object> toMap(Event event) {
        if (event != null) {
            HashMap<String, Object> mapEvent = new HashMap<String, Object>();
            Object[] data = event.getData();
            List attributeList = this.streamDefinition.getAttributeList();
            mapEvent.put("_timestamp", event.getTimestamp());
            for (int i = 0; i < data.length; ++i) {
                mapEvent.put(((Attribute)attributeList.get(i)).getName(), data[i]);
            }
            return mapEvent;
        }
        return null;
    }

    public Map<String, Object>[] toMap(Event[] events) {
        if (events != null) {
            Map[] mapEvents = new Map[events.length];
            for (int i = 0; i < events.length; ++i) {
                mapEvents[i] = this.toMap(events[i]);
            }
            return mapEvents;
        }
        return null;
    }

    @Override
    public void receive(ComplexEvent complexEvent) {
        ArrayList<Event> eventBuffer = new ArrayList<Event>();
        while (complexEvent != null) {
            eventBuffer.add(new Event(complexEvent.getOutputData().length).copyFrom(complexEvent));
            complexEvent = complexEvent.getNext();
        }
        if (eventBuffer.size() == 1) {
            this.receive((Event)eventBuffer.get(0));
        } else {
            this.receiveEvents(eventBuffer.toArray(new Event[eventBuffer.size()]));
        }
    }

    @Override
    public void receive(Event event) {
        this.receiveEvents(new Event[]{event});
    }

    @Override
    public void receive(List<Event> events) {
        this.receiveEvents(events.toArray(new Event[events.size()]));
    }

    @Override
    public void receive(long timestamp, Object[] data) {
        this.receiveEvents(new Event[]{new Event(timestamp, data)});
    }

    public void receiveEvents(Event[] events) {
        try {
            this.receive(events);
        }
        catch (RuntimeException e) {
            log.error((Object)("Error on sending events " + Arrays.deepToString(events) + " in the SiddhiApp '" + this.siddhiAppContext.getName() + "'"), (Throwable)e);
        }
    }

    @Override
    public abstract void receive(Event[] var1);

    public synchronized void startProcessing() {
    }

    public synchronized void stopProcessing() {
    }
}

