/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.stream.output.sink.distributed;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.core.stream.output.sink.distributed.DistributionStrategy;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.transport.DynamicOptions;
import org.wso2.siddhi.core.util.transport.OptionHolder;
import org.wso2.siddhi.query.api.definition.StreamDefinition;

@Extension(name="roundRobin", namespace="distributionStrategy", description="Publishing strategy to implement messages in a round robin manner to multiple destinations.", examples={@Example(syntax="@sink(type='tcp', @map(type='text'),\n@distribution(strategy='roundRobin',\n@destination(topic = 'topic1'),\n@destination(topic = 'topic2')))\ndefine stream BarStream (symbol string, price float, volume long);", description="In this example BarStream sink will act as round robin strategy to 'topic1' and 'topic2' destinations.")})
public class RoundRobinDistributionStrategy
extends DistributionStrategy {
    private int count = 0;
    private int destinationCount;
    private List<Integer> returnValue = new ArrayList<Integer>();

    @Override
    public void init(StreamDefinition streamDefinition, OptionHolder transportOptionHolder, OptionHolder distributionOptionHolder, List<OptionHolder> destinationOptionHolders, ConfigReader configReader) {
    }

    @Override
    public List<Integer> getDestinationsToPublish(Object payload, DynamicOptions transportOptions) {
        if (this.activeDestinationIds.isEmpty()) {
            return DistributionStrategy.EMPTY_RETURN_VALUE;
        }
        int currentDestinationCount = this.activeDestinationIds.size();
        if (this.destinationCount != currentDestinationCount) {
            this.destinationCount = currentDestinationCount;
        }
        if (!this.returnValue.isEmpty()) {
            this.returnValue.remove(0);
        }
        if (this.destinationCount > 0) {
            this.returnValue.add((Integer)this.activeDestinationIds.get(this.count++ % this.destinationCount));
        }
        return this.returnValue;
    }
}

