/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.trigger;

import org.apache.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.StreamJunction;
import org.wso2.siddhi.core.trigger.Trigger;
import org.wso2.siddhi.core.util.ExceptionUtil;
import org.wso2.siddhi.core.util.parser.helper.QueryParserHelper;
import org.wso2.siddhi.core.util.statistics.ThroughputTracker;
import org.wso2.siddhi.query.api.definition.TriggerDefinition;

public class CronTrigger
implements Trigger,
Job {
    protected static final Logger LOG = Logger.getLogger(CronTrigger.class);
    private TriggerDefinition triggerDefinition;
    private SiddhiAppContext siddhiAppContext;
    private StreamJunction streamJunction;
    private Scheduler scheduler;
    private String jobName;
    private String jobGroup = "TriggerGroup";
    private ThroughputTracker throughputTracker;

    @Override
    public void init(TriggerDefinition triggerDefinition, SiddhiAppContext siddhiAppContext, StreamJunction streamJunction) {
        this.triggerDefinition = triggerDefinition;
        this.siddhiAppContext = siddhiAppContext;
        this.streamJunction = streamJunction;
        if (siddhiAppContext.getStatisticsManager() != null) {
            this.throughputTracker = QueryParserHelper.createThroughputTracker(siddhiAppContext, triggerDefinition.getId(), "Trigger", null);
        }
    }

    @Override
    public TriggerDefinition getTriggerDefinition() {
        return this.triggerDefinition;
    }

    @Override
    public String getId() {
        return this.triggerDefinition.getId();
    }

    @Override
    public void start() {
        this.scheduleCronJob(this.triggerDefinition.getAt(), this.triggerDefinition.getId());
    }

    @Override
    public void stop() {
        try {
            if (this.scheduler != null) {
                this.scheduler.deleteJob(new JobKey(this.jobName, this.jobGroup));
            }
        }
        catch (SchedulerException e) {
            LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Error while removing the cron trigger job '" + this.jobGroup + "':'" + this.jobName + "'"), (Throwable)e);
        }
    }

    private void scheduleCronJob(String cronString, String elementId) {
        try {
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
            this.scheduler = schedulerFactory.getScheduler();
            this.jobName = "TriggerJob_" + elementId;
            JobKey jobKey = new JobKey(this.jobName, this.jobGroup);
            if (this.scheduler.checkExists(jobKey)) {
                this.scheduler.deleteJob(jobKey);
            }
            this.scheduler.start();
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("trigger", (Object)this);
            JobDetail job = JobBuilder.newJob(CronTrigger.class).withIdentity(this.jobName, this.jobGroup).usingJobData(dataMap).build();
            org.quartz.Trigger trigger = TriggerBuilder.newTrigger().withIdentity("TriggerJob_" + elementId, this.jobGroup).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronString)).build();
            this.scheduler.scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            LOG.error((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Error while instantiating quartz scheduler for trigger '" + this.triggerDefinition.getId() + "'."), (Throwable)e);
        }
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap dataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        CronTrigger cronEventTrigger = (CronTrigger)dataMap.get((Object)"trigger");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Running Trigger Job '" + cronEventTrigger.getId() + "'"));
        }
        cronEventTrigger.sendEvent();
    }

    private void sendEvent() {
        long currentTime = this.siddhiAppContext.getTimestampGenerator().currentTime();
        if (this.throughputTracker != null && this.siddhiAppContext.isStatsEnabled()) {
            this.throughputTracker.eventIn();
        }
        this.streamJunction.sendEvent(new Event(currentTime, new Object[]{currentTime}));
    }
}

