/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.collection.executor;

import java.util.Collection;
import java.util.HashSet;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.table.holder.IndexedEventHolder;
import org.wso2.siddhi.core.util.collection.executor.CollectionExecutor;
import org.wso2.siddhi.core.util.collection.executor.ExhaustiveCollectionExecutor;

public class AnyAndCollectionExecutor
implements CollectionExecutor {
    private final CollectionExecutor highCostCollectionExecutor;
    private final CollectionExecutor lowCollectionExecutor;
    private ExhaustiveCollectionExecutor exhaustiveCollectionExecutor;

    public AnyAndCollectionExecutor(CollectionExecutor leftCollectionExecutor, CollectionExecutor rightCostCollectionExecutor, ExhaustiveCollectionExecutor exhaustiveCollectionExecutor) {
        if (leftCollectionExecutor.getDefaultCost().getWeight() <= rightCostCollectionExecutor.getDefaultCost().getWeight()) {
            this.lowCollectionExecutor = leftCollectionExecutor;
            this.highCostCollectionExecutor = rightCostCollectionExecutor;
        } else {
            this.lowCollectionExecutor = rightCostCollectionExecutor;
            this.highCostCollectionExecutor = leftCollectionExecutor;
        }
        this.exhaustiveCollectionExecutor = exhaustiveCollectionExecutor;
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder, StreamEventCloner storeEventCloner) {
        Collection<StreamEvent> resultEventSet = this.findEvents(matchingEvent, indexedEventHolder);
        ComplexEventChunk<StreamEvent> returnEventChunk = new ComplexEventChunk<StreamEvent>(false);
        if (resultEventSet != null) {
            for (StreamEvent resultEvent : resultEventSet) {
                if (storeEventCloner != null) {
                    returnEventChunk.add(storeEventCloner.copyStreamEvent(resultEvent));
                    continue;
                }
                returnEventChunk.add(resultEvent);
            }
            return (StreamEvent)returnEventChunk.getFirst();
        }
        return this.exhaustiveCollectionExecutor.find(matchingEvent, indexedEventHolder, storeEventCloner);
    }

    @Override
    public Collection<StreamEvent> findEvents(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        Collection<StreamEvent> lowCostStreamEvents = this.lowCollectionExecutor.findEvents(matchingEvent, indexedEventHolder);
        if (lowCostStreamEvents == null) {
            return null;
        }
        if (lowCostStreamEvents.size() > 0) {
            if (lowCostStreamEvents.size() <= 10) {
                return this.exhaustiveCollectionExecutor.findEvents(matchingEvent, lowCostStreamEvents);
            }
            Collection<StreamEvent> highCostStreamEvents = this.highCostCollectionExecutor.findEvents(matchingEvent, indexedEventHolder);
            if (highCostStreamEvents == null) {
                return null;
            }
            if (highCostStreamEvents.size() > 0) {
                if (lowCostStreamEvents.size() <= 10) {
                    return this.exhaustiveCollectionExecutor.findEvents(matchingEvent, highCostStreamEvents);
                }
                HashSet<StreamEvent> returnSet = new HashSet<StreamEvent>();
                if (highCostStreamEvents.size() > lowCostStreamEvents.size()) {
                    for (StreamEvent aStreamEvent : lowCostStreamEvents) {
                        if (!highCostStreamEvents.contains(aStreamEvent)) continue;
                        returnSet.add(aStreamEvent);
                    }
                } else {
                    for (StreamEvent aStreamEvent : highCostStreamEvents) {
                        if (!lowCostStreamEvents.contains(aStreamEvent)) continue;
                        returnSet.add(aStreamEvent);
                    }
                }
                return returnSet;
            }
            return highCostStreamEvents;
        }
        return lowCostStreamEvents;
    }

    @Override
    public boolean contains(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        Collection<StreamEvent> resultEventSet = this.findEvents(matchingEvent, indexedEventHolder);
        if (resultEventSet != null) {
            return resultEventSet.size() > 0;
        }
        return this.exhaustiveCollectionExecutor.contains(matchingEvent, indexedEventHolder);
    }

    @Override
    public void delete(StateEvent deletingEvent, IndexedEventHolder indexedEventHolder) {
        Collection<StreamEvent> resultEventSet = this.findEvents(deletingEvent, indexedEventHolder);
        if (resultEventSet != null) {
            indexedEventHolder.deleteAll(resultEventSet);
        } else {
            this.exhaustiveCollectionExecutor.delete(deletingEvent, indexedEventHolder);
        }
    }

    @Override
    public CollectionExecutor.Cost getDefaultCost() {
        return this.lowCollectionExecutor.getDefaultCost();
    }
}

