/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.collection.executor;

import java.util.Collection;
import java.util.HashSet;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.table.holder.IndexedEventHolder;
import org.wso2.siddhi.core.util.collection.executor.CollectionExecutor;

public class NonCollectionExecutor
implements CollectionExecutor {
    private ExpressionExecutor expressionExecutor;

    public NonCollectionExecutor(ExpressionExecutor expressionExecutor) {
        this.expressionExecutor = expressionExecutor;
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder, StreamEventCloner storeEventCloner) {
        if (((Boolean)this.expressionExecutor.execute(matchingEvent)).booleanValue()) {
            ComplexEventChunk<StreamEvent> returnEventChunk = new ComplexEventChunk<StreamEvent>(false);
            Collection<StreamEvent> storeEvents = indexedEventHolder.getAllEvents();
            for (StreamEvent storeEvent : storeEvents) {
                if (storeEventCloner != null) {
                    returnEventChunk.add(storeEventCloner.copyStreamEvent(storeEvent));
                    continue;
                }
                returnEventChunk.add(storeEvent);
            }
            return (StreamEvent)returnEventChunk.getFirst();
        }
        return null;
    }

    @Override
    public Collection<StreamEvent> findEvents(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        if (((Boolean)this.expressionExecutor.execute(matchingEvent)).booleanValue()) {
            return indexedEventHolder.getAllEvents();
        }
        return new HashSet<StreamEvent>();
    }

    @Override
    public boolean contains(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        return (Boolean)this.expressionExecutor.execute(matchingEvent);
    }

    @Override
    public void delete(StateEvent deletingEvent, IndexedEventHolder indexedEventHolder) {
        if (((Boolean)this.expressionExecutor.execute(deletingEvent)).booleanValue()) {
            indexedEventHolder.deleteAll();
        }
    }

    @Override
    public CollectionExecutor.Cost getDefaultCost() {
        return CollectionExecutor.Cost.MULTI_RETURN_INDEX_MATCHING;
    }
}

