/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.parser;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.holder.SnapshotableStreamEventQueue;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.table.holder.IndexedEventHolder;
import org.wso2.siddhi.core.util.collection.executor.CollectionExecutor;
import org.wso2.siddhi.core.util.collection.expression.AndMultiPrimaryKeyCollectionExpression;
import org.wso2.siddhi.core.util.collection.expression.AttributeCollectionExpression;
import org.wso2.siddhi.core.util.collection.expression.CollectionExpression;
import org.wso2.siddhi.core.util.collection.expression.CompareCollectionExpression;
import org.wso2.siddhi.core.util.collection.operator.CollectionOperator;
import org.wso2.siddhi.core.util.collection.operator.EventChunkOperator;
import org.wso2.siddhi.core.util.collection.operator.IndexOperator;
import org.wso2.siddhi.core.util.collection.operator.MapOperator;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.core.util.collection.operator.OverwriteTableIndexOperator;
import org.wso2.siddhi.core.util.collection.operator.SnapshotableEventQueueOperator;
import org.wso2.siddhi.core.util.parser.CollectionExpressionParser;
import org.wso2.siddhi.core.util.parser.ExpressionParser;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.Variable;
import org.wso2.siddhi.query.api.expression.condition.Compare;

public class OperatorParser {
    public static Operator constructOperator(Object storeEvents, Expression expression, MatchingMetaInfoHolder matchingMetaInfoHolder, SiddhiAppContext siddhiAppContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, String queryName) {
        if (storeEvents instanceof IndexedEventHolder) {
            CollectionExpression collectionExpression = CollectionExpressionParser.parseCollectionExpression(expression, matchingMetaInfoHolder, (IndexedEventHolder)storeEvents);
            CollectionExecutor collectionExecutor = CollectionExpressionParser.buildCollectionExecutor(collectionExpression, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiAppContext, true, queryName);
            if (collectionExpression instanceof CompareCollectionExpression && ((CompareCollectionExpression)collectionExpression).getOperator() == Compare.Operator.EQUAL && (collectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.INDEXED_RESULT_SET || collectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.PRIMARY_KEY_RESULT_SET) && ((IndexedEventHolder)storeEvents).getPrimaryKeyReferenceHolders() != null && ((IndexedEventHolder)storeEvents).getPrimaryKeyReferenceHolders().length == 1 && ((IndexedEventHolder)storeEvents).getPrimaryKeyReferenceHolders()[0].getPrimaryKeyAttribute().equals(((AttributeCollectionExpression)((CompareCollectionExpression)collectionExpression).getAttributeCollectionExpression()).getAttribute())) {
                return new OverwriteTableIndexOperator(collectionExecutor, queryName);
            }
            if (collectionExpression instanceof AndMultiPrimaryKeyCollectionExpression && collectionExpression.getCollectionScope() == CollectionExpression.CollectionScope.PRIMARY_KEY_RESULT_SET) {
                return new OverwriteTableIndexOperator(collectionExecutor, queryName);
            }
            return new IndexOperator(collectionExecutor, queryName);
        }
        if (storeEvents instanceof ComplexEventChunk) {
            ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(expression, matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
            return new EventChunkOperator(expressionExecutor, matchingMetaInfoHolder.getStoreEventIndex());
        }
        if (storeEvents instanceof SnapshotableStreamEventQueue) {
            ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(expression, matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
            return new SnapshotableEventQueueOperator(expressionExecutor, matchingMetaInfoHolder.getStoreEventIndex());
        }
        if (storeEvents instanceof Map) {
            ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(expression, matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
            return new MapOperator(expressionExecutor, matchingMetaInfoHolder.getStoreEventIndex());
        }
        if (storeEvents instanceof Collection) {
            ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(expression, matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, siddhiAppContext, false, 0, queryName);
            return new CollectionOperator(expressionExecutor, matchingMetaInfoHolder.getStoreEventIndex());
        }
        throw new OperationNotSupportedException(storeEvents.getClass() + " is not supported by OperatorParser!");
    }

    private static boolean isTableIndexVariable(MatchingMetaInfoHolder matchingMetaInfoHolder, Expression expression, String indexAttribute) {
        MetaStreamEvent tableStreamEvent;
        Variable variable;
        return expression instanceof Variable && (variable = (Variable)expression).getStreamId() != null && (tableStreamEvent = matchingMetaInfoHolder.getMetaStateEvent().getMetaStreamEvent(matchingMetaInfoHolder.getStoreEventIndex())) != null && (tableStreamEvent.getInputReferenceId() != null && variable.getStreamId().equals(tableStreamEvent.getInputReferenceId()) || tableStreamEvent.getLastInputDefinition().getId().equals(variable.getStreamId())) && Arrays.asList(tableStreamEvent.getLastInputDefinition().getAttributeNameArray()).contains(indexAttribute);
    }
}

