/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.parser.helper;

import java.util.List;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.MetaComplexEvent;
import org.wso2.siddhi.core.event.state.MetaStateEvent;
import org.wso2.siddhi.core.event.state.MetaStateEventAttribute;
import org.wso2.siddhi.core.event.state.StateEventCloner;
import org.wso2.siddhi.core.event.state.StateEventPool;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.event.stream.populater.StreamEventPopulaterFactory;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.input.ProcessStreamReceiver;
import org.wso2.siddhi.core.query.input.stream.StreamRuntime;
import org.wso2.siddhi.core.query.input.stream.join.JoinProcessor;
import org.wso2.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import org.wso2.siddhi.core.query.input.stream.state.StreamPreStateProcessor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.SchedulingProcessor;
import org.wso2.siddhi.core.query.processor.stream.AbstractStreamProcessor;
import org.wso2.siddhi.core.util.collection.operator.IncrementalAggregateCompileCondition;
import org.wso2.siddhi.core.util.lock.LockWrapper;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;
import org.wso2.siddhi.core.util.statistics.MemoryUsageTracker;
import org.wso2.siddhi.core.util.statistics.ThroughputTracker;
import org.wso2.siddhi.query.api.definition.Attribute;

public class QueryParserHelper {
    public static void reduceMetaComplexEvent(MetaComplexEvent metaComplexEvent) {
        if (metaComplexEvent instanceof MetaStateEvent) {
            MetaStateEvent metaStateEvent = (MetaStateEvent)metaComplexEvent;
            for (MetaStateEventAttribute attribute : metaStateEvent.getOutputDataAttributes()) {
                if (attribute == null) continue;
                metaStateEvent.getMetaStreamEvent(attribute.getPosition()[0]).addOutputData(attribute.getAttribute());
            }
            for (MetaStreamEvent metaStreamEvent : metaStateEvent.getMetaStreamEvents()) {
                QueryParserHelper.reduceStreamAttributes(metaStreamEvent);
            }
        } else {
            QueryParserHelper.reduceStreamAttributes((MetaStreamEvent)metaComplexEvent);
        }
    }

    private static synchronized void reduceStreamAttributes(MetaStreamEvent metaStreamEvent) {
        for (Attribute attribute : metaStreamEvent.getOutputData()) {
            if (metaStreamEvent.getBeforeWindowData().contains(attribute)) {
                metaStreamEvent.getBeforeWindowData().remove(attribute);
            }
            if (!metaStreamEvent.getOnAfterWindowData().contains(attribute)) continue;
            metaStreamEvent.getOnAfterWindowData().remove(attribute);
        }
        for (Attribute attribute : metaStreamEvent.getOnAfterWindowData()) {
            if (!metaStreamEvent.getBeforeWindowData().contains(attribute)) continue;
            metaStreamEvent.getBeforeWindowData().remove(attribute);
        }
    }

    public static void updateVariablePosition(MetaComplexEvent metaComplexEvent, List<VariableExpressionExecutor> variableExpressionExecutorList) {
        for (VariableExpressionExecutor variableExpressionExecutor : variableExpressionExecutorList) {
            int streamEventChainIndex = variableExpressionExecutor.getPosition()[0];
            if (streamEventChainIndex == -2) {
                variableExpressionExecutor.getPosition()[2] = metaComplexEvent instanceof MetaStreamEvent ? 2 : 3;
                variableExpressionExecutor.getPosition()[0] = -1;
                variableExpressionExecutor.getPosition()[3] = metaComplexEvent.getOutputStreamDefinition().getAttributeList().indexOf(variableExpressionExecutor.getAttribute());
                continue;
            }
            if (metaComplexEvent instanceof MetaStreamEvent && streamEventChainIndex >= 1 || metaComplexEvent instanceof MetaStateEvent && streamEventChainIndex >= ((MetaStateEvent)metaComplexEvent).getMetaStreamEvents().length) continue;
            MetaStreamEvent metaStreamEvent = metaComplexEvent instanceof MetaStreamEvent ? (MetaStreamEvent)metaComplexEvent : ((MetaStateEvent)metaComplexEvent).getMetaStreamEvent(streamEventChainIndex);
            if (metaStreamEvent.getOutputData().contains(variableExpressionExecutor.getAttribute())) {
                variableExpressionExecutor.getPosition()[2] = 2;
                variableExpressionExecutor.getPosition()[3] = metaStreamEvent.getOutputData().indexOf(variableExpressionExecutor.getAttribute());
                continue;
            }
            if (metaStreamEvent.getOnAfterWindowData().contains(variableExpressionExecutor.getAttribute())) {
                variableExpressionExecutor.getPosition()[2] = 1;
                variableExpressionExecutor.getPosition()[3] = metaStreamEvent.getOnAfterWindowData().indexOf(variableExpressionExecutor.getAttribute());
                continue;
            }
            if (!metaStreamEvent.getBeforeWindowData().contains(variableExpressionExecutor.getAttribute())) continue;
            variableExpressionExecutor.getPosition()[2] = 0;
            variableExpressionExecutor.getPosition()[3] = metaStreamEvent.getBeforeWindowData().indexOf(variableExpressionExecutor.getAttribute());
        }
    }

    public static void initStreamRuntime(StreamRuntime runtime, MetaComplexEvent metaComplexEvent, LockWrapper lockWrapper, String queryName) {
        if (runtime instanceof SingleStreamRuntime) {
            QueryParserHelper.initSingleStreamRuntime((SingleStreamRuntime)runtime, 0, metaComplexEvent, null, lockWrapper, queryName);
        } else {
            MetaStateEvent metaStateEvent = (MetaStateEvent)metaComplexEvent;
            StateEventPool stateEventPool = new StateEventPool(metaStateEvent, 5);
            MetaStreamEvent[] metaStreamEvents = metaStateEvent.getMetaStreamEvents();
            int metaStreamEventsLength = metaStreamEvents.length;
            for (int i = 0; i < metaStreamEventsLength; ++i) {
                QueryParserHelper.initSingleStreamRuntime(runtime.getSingleStreamRuntimes().get(i), i, metaStateEvent, stateEventPool, lockWrapper, queryName);
            }
        }
    }

    private static void initSingleStreamRuntime(SingleStreamRuntime singleStreamRuntime, int streamEventChainIndex, MetaComplexEvent metaComplexEvent, StateEventPool stateEventPool, LockWrapper lockWrapper, String queryName) {
        MetaStreamEvent metaStreamEvent = metaComplexEvent instanceof MetaStateEvent ? ((MetaStateEvent)metaComplexEvent).getMetaStreamEvent(streamEventChainIndex) : (MetaStreamEvent)metaComplexEvent;
        StreamEventPool streamEventPool = new StreamEventPool(metaStreamEvent, 5);
        ProcessStreamReceiver processStreamReceiver = singleStreamRuntime.getProcessStreamReceiver();
        processStreamReceiver.setMetaStreamEvent(metaStreamEvent);
        processStreamReceiver.setStreamEventPool(streamEventPool);
        processStreamReceiver.setLockWrapper(lockWrapper);
        processStreamReceiver.init();
        for (Processor processor = singleStreamRuntime.getProcessorChain(); processor != null; processor = processor.getNextProcessor()) {
            if (processor instanceof SchedulingProcessor) {
                ((SchedulingProcessor)processor).getScheduler().setStreamEventPool(streamEventPool);
                ((SchedulingProcessor)processor).getScheduler().init(lockWrapper, queryName);
            }
            if (processor instanceof AbstractStreamProcessor) {
                ((AbstractStreamProcessor)processor).setStreamEventCloner(new StreamEventCloner(metaStreamEvent, streamEventPool));
                ((AbstractStreamProcessor)processor).constructStreamEventPopulater(metaStreamEvent, streamEventChainIndex);
            }
            if (stateEventPool != null && processor instanceof JoinProcessor) {
                if (((JoinProcessor)processor).getCompiledCondition() instanceof IncrementalAggregateCompileCondition) {
                    IncrementalAggregateCompileCondition compiledCondition = (IncrementalAggregateCompileCondition)((JoinProcessor)processor).getCompiledCondition();
                    ComplexEventPopulater complexEventPopulater = StreamEventPopulaterFactory.constructEventPopulator(metaStreamEvent, 0, compiledCondition.getAdditionalAttributes());
                    compiledCondition.setComplexEventPopulater(complexEventPopulater);
                }
                ((JoinProcessor)processor).setStateEventPool(stateEventPool);
            }
            if (stateEventPool == null || !(processor instanceof StreamPreStateProcessor)) continue;
            ((StreamPreStateProcessor)processor).setStateEventPool(stateEventPool);
            ((StreamPreStateProcessor)processor).setStreamEventPool(streamEventPool);
            ((StreamPreStateProcessor)processor).setStreamEventCloner(new StreamEventCloner(metaStreamEvent, streamEventPool));
            if (!(metaComplexEvent instanceof MetaStateEvent)) continue;
            ((StreamPreStateProcessor)processor).setStateEventCloner(new StateEventCloner((MetaStateEvent)metaComplexEvent, stateEventPool));
        }
    }

    public static LatencyTracker createLatencyTracker(SiddhiAppContext siddhiAppContext, String name, String type, String function) {
        LatencyTracker latencyTracker = null;
        if (siddhiAppContext.getStatisticsManager() != null) {
            String metricName = siddhiAppContext.getSiddhiContext().getStatisticsConfiguration().getMetricPrefix() + "." + "SiddhiApps" + "." + siddhiAppContext.getName() + "." + "Siddhi" + "." + type + "." + name;
            if (function != null) {
                metricName = metricName + "." + function;
            }
            metricName = metricName + ".latency";
            boolean matchExist = false;
            for (String regex : siddhiAppContext.getIncludedMetrics()) {
                if (!metricName.matches(regex)) continue;
                matchExist = true;
                break;
            }
            if (matchExist) {
                latencyTracker = siddhiAppContext.getSiddhiContext().getStatisticsConfiguration().getFactory().createLatencyTracker(metricName, siddhiAppContext.getStatisticsManager());
            }
        }
        return latencyTracker;
    }

    public static ThroughputTracker createThroughputTracker(SiddhiAppContext siddhiAppContext, String name, String type, String function) {
        ThroughputTracker throughputTracker = null;
        if (siddhiAppContext.getStatisticsManager() != null) {
            String metricName = siddhiAppContext.getSiddhiContext().getStatisticsConfiguration().getMetricPrefix() + "." + "SiddhiApps" + "." + siddhiAppContext.getName() + "." + "Siddhi" + "." + type + "." + name;
            if (function != null) {
                metricName = metricName + "." + function;
            }
            metricName = metricName + ".throughput";
            boolean matchExist = false;
            for (String regex : siddhiAppContext.getIncludedMetrics()) {
                if (!metricName.matches(regex)) continue;
                matchExist = true;
                break;
            }
            if (matchExist) {
                throughputTracker = siddhiAppContext.getSiddhiContext().getStatisticsConfiguration().getFactory().createThroughputTracker(metricName, siddhiAppContext.getStatisticsManager());
            }
        }
        return throughputTracker;
    }

    public static void registerMemoryUsageTracking(String name, Object value, String metricInfixQueries, SiddhiAppContext siddhiAppContext, MemoryUsageTracker memoryUsageTracker) {
        String metricName = siddhiAppContext.getSiddhiContext().getStatisticsConfiguration().getMetricPrefix() + "." + "SiddhiApps" + "." + siddhiAppContext.getName() + "." + "Siddhi" + "." + metricInfixQueries + "." + name + "." + "memory";
        boolean matchExist = false;
        for (String regex : siddhiAppContext.getIncludedMetrics()) {
            if (!metricName.matches(regex)) continue;
            matchExist = true;
            break;
        }
        if (matchExist) {
            memoryUsageTracker.registerObject(value, metricName);
        }
    }
}

