/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.snapshot;

import org.apache.log4j.Logger;
import org.wso2.siddhi.core.exception.NoPersistenceStoreException;
import org.wso2.siddhi.core.util.persistence.PersistenceStore;

public class AsyncSnapshotPersistor
implements Runnable {
    private static final Logger log = Logger.getLogger(AsyncSnapshotPersistor.class);
    private byte[] snapshots;
    private PersistenceStore persistenceStore;
    private String siddhiAppName;
    private String revision;
    private long time;

    public AsyncSnapshotPersistor(byte[] snapshots, PersistenceStore persistenceStore, String siddhiAppName, long time) {
        if (persistenceStore == null) {
            throw new NoPersistenceStoreException("No persistence store assigned for siddhi app '" + siddhiAppName + "'");
        }
        this.snapshots = snapshots;
        this.persistenceStore = persistenceStore;
        this.siddhiAppName = siddhiAppName;
        this.time = time;
        this.revision = time + "__" + siddhiAppName;
    }

    public String getRevision() {
        return this.revision;
    }

    @Override
    public void run() {
        if (this.persistenceStore != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Persisting...");
            }
            this.persistenceStore.save(this.siddhiAppName, this.revision, this.snapshots);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Persisted.");
            }
        } else {
            throw new NoPersistenceStoreException("No persistence store assigned for siddhi app " + this.siddhiAppName);
        }
    }
}

