/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.snapshot;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.CannotClearSiddhiAppStateException;
import org.wso2.siddhi.core.exception.CannotRestoreSiddhiAppStateException;
import org.wso2.siddhi.core.exception.NoPersistenceStoreException;
import org.wso2.siddhi.core.exception.PersistenceStoreException;
import org.wso2.siddhi.core.util.ThreadBarrier;
import org.wso2.siddhi.core.util.persistence.IncrementalPersistenceStore;
import org.wso2.siddhi.core.util.persistence.PersistenceStore;
import org.wso2.siddhi.core.util.persistence.util.IncrementalSnapshotInfo;
import org.wso2.siddhi.core.util.persistence.util.PersistenceHelper;
import org.wso2.siddhi.core.util.snapshot.ByteSerializer;
import org.wso2.siddhi.core.util.snapshot.IncrementalSnapshot;
import org.wso2.siddhi.core.util.snapshot.SnapshotRequest;
import org.wso2.siddhi.core.util.snapshot.Snapshotable;
import org.wso2.siddhi.core.util.snapshot.state.SnapshotState;
import org.wso2.siddhi.core.util.snapshot.state.SnapshotStateList;

public class SnapshotService {
    private static final Logger log = Logger.getLogger(SnapshotService.class);
    private static final ThreadLocal<Boolean> skipSnapshotableThreadLocal = new ThreadLocal();
    private final ThreadBarrier threadBarrier;
    private ConcurrentHashMap<String, Map<String, Snapshotable>> snapshotableMap = new ConcurrentHashMap();
    private SiddhiAppContext siddhiAppContext;

    public SnapshotService(SiddhiAppContext siddhiAppContext) {
        this.siddhiAppContext = siddhiAppContext;
        this.threadBarrier = siddhiAppContext.getThreadBarrier();
    }

    public static ThreadLocal<Boolean> getSkipSnapshotableThreadLocal() {
        return skipSnapshotableThreadLocal;
    }

    public ConcurrentHashMap<String, Map<String, Snapshotable>> getSnapshotableMap() {
        return this.snapshotableMap;
    }

    public synchronized void addSnapshotable(String snapshotableName, Snapshotable snapshotable) {
        Boolean skipSnapshotable = skipSnapshotableThreadLocal.get();
        if (skipSnapshotable == null || !skipSnapshotable.booleanValue()) {
            Map<String, Snapshotable> snapshotableMap = this.snapshotableMap.get(snapshotableName);
            if (snapshotableMap == null) {
                snapshotableMap = new HashMap<String, Snapshotable>();
                snapshotableMap.put(snapshotable.getElementId(), snapshotable);
                this.snapshotableMap.put(snapshotableName, snapshotableMap);
            } else {
                snapshotableMap.putIfAbsent(snapshotable.getElementId(), snapshotable);
            }
        }
    }

    public synchronized void removeSnapshotable(String snapshotableName, Snapshotable snapshotable) {
        Map<String, Snapshotable> snapshotableMap;
        Boolean skipSnapshotable = skipSnapshotableThreadLocal.get();
        if (!(skipSnapshotable != null && skipSnapshotable.booleanValue() || (snapshotableMap = this.snapshotableMap.get(snapshotableName)) == null)) {
            snapshotableMap = new HashMap<String, Snapshotable>();
            snapshotableMap.remove(snapshotable.getElementId(), snapshotable);
            if (snapshotableMap.isEmpty()) {
                this.snapshotableMap.remove(snapshotableName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] fullSnapshot() {
        try {
            SnapshotRequest.requestForFullSnapshot(true);
            HashMap elementSnapshotMapFull = new HashMap();
            byte[] serializedFullState = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Taking snapshot ...");
            }
            try {
                this.threadBarrier.lock();
                for (Map.Entry<String, Map<String, Snapshotable>> entry : this.snapshotableMap.entrySet()) {
                    HashMap elementWiseFullSnapshots = new HashMap();
                    for (Map.Entry<String, Snapshotable> snapshotableEntry : entry.getValue().entrySet()) {
                        Snapshotable snapshotableObj = snapshotableEntry.getValue();
                        Map<String, Object> currentState = snapshotableEntry.getValue().currentState();
                        if (currentState == null) continue;
                        HashMap<String, Object> elementWiseSnapshots = new HashMap<String, Object>();
                        for (Map.Entry<String, Object> item2 : currentState.entrySet()) {
                            String key = item2.getKey();
                            Object snapShot = item2.getValue();
                            if (snapShot instanceof SnapshotState) {
                                if (((SnapshotState)snapShot).isIncrementalSnapshot()) {
                                    throw new NoPersistenceStoreException("No incremental persistence store exist to store incremental snapshot of siddhiApp:'" + this.siddhiAppContext.getName() + "' subElement:'" + entry.getKey() + "' elementId:'" + snapshotableObj.getElementId() + "' and key:'" + key + "'");
                                }
                                elementWiseSnapshots.put(key, snapShot);
                                continue;
                            }
                            elementWiseSnapshots.put(key, snapShot);
                        }
                        if (elementWiseSnapshots.isEmpty()) continue;
                        elementWiseFullSnapshots.put(snapshotableObj.getElementId(), elementWiseSnapshots);
                    }
                    if (elementWiseFullSnapshots.isEmpty()) continue;
                    elementSnapshotMapFull.put(entry.getKey(), elementWiseFullSnapshots);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SnapshotState serialization started ...");
                }
                serializedFullState = ByteSerializer.objectToByte(elementSnapshotMapFull, this.siddhiAppContext);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SnapshotState serialization finished.");
                }
            }
            finally {
                this.threadBarrier.unlock();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("SnapshotState taken for Siddhi app '" + this.siddhiAppContext.getName() + "'"));
            }
            Object object = serializedFullState;
            return object;
        }
        finally {
            SnapshotRequest.requestForFullSnapshot(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrementalSnapshot incrementalSnapshot() {
        try {
            SnapshotRequest.requestForFullSnapshot(false);
            HashMap<String, Map<String, byte[]>> elementSnapshotMapIncremental = new HashMap<String, Map<String, byte[]>>();
            HashMap<String, Map<String, byte[]>> elementSnapshotMapIncrementalBase = new HashMap<String, Map<String, byte[]>>();
            HashMap<String, Map<String, byte[]>> elementSnapshotMapPeriodic = new HashMap<String, Map<String, byte[]>>();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Taking snapshot ...");
            }
            try {
                this.threadBarrier.lock();
                for (Map.Entry<String, Map<String, Snapshotable>> entry : this.snapshotableMap.entrySet()) {
                    HashMap<String, byte[]> elementWiseIncrementalSnapshots = new HashMap<String, byte[]>();
                    HashMap<String, byte[]> elementWiseIncrementalSnapshotsBase = new HashMap<String, byte[]>();
                    HashMap<String, byte[]> elementWisePeriodicSnapshots = new HashMap<String, byte[]>();
                    for (Map.Entry<String, Snapshotable> snapshotableEntry : entry.getValue().entrySet()) {
                        Snapshotable snapshotableObj = snapshotableEntry.getValue();
                        Map<String, Object> currentState = snapshotableObj.currentState();
                        if (currentState == null) continue;
                        HashMap<String, Object> incrementalSnapshotableMap = new HashMap<String, Object>();
                        HashMap<String, Object> incrementalSnapshotableMapBase = new HashMap<String, Object>();
                        HashMap<String, Object> periodicSnapshotableMap = new HashMap<String, Object>();
                        for (Map.Entry<String, Object> stateEntry : currentState.entrySet()) {
                            String key = stateEntry.getKey();
                            Object snapShot = stateEntry.getValue();
                            if (snapShot instanceof SnapshotState) {
                                if (((SnapshotState)snapShot).isIncrementalSnapshot()) {
                                    incrementalSnapshotableMap.put(key, snapShot);
                                    continue;
                                }
                                incrementalSnapshotableMapBase.put(key, snapShot);
                                continue;
                            }
                            periodicSnapshotableMap.put(key, snapShot);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"SnapshotState serialization started ...");
                        }
                        if (!incrementalSnapshotableMap.isEmpty()) {
                            elementWiseIncrementalSnapshots.put(snapshotableObj.getElementId(), ByteSerializer.objectToByte(incrementalSnapshotableMap, this.siddhiAppContext));
                        }
                        if (!incrementalSnapshotableMapBase.isEmpty()) {
                            elementWiseIncrementalSnapshotsBase.put(snapshotableObj.getElementId(), ByteSerializer.objectToByte(incrementalSnapshotableMapBase, this.siddhiAppContext));
                        }
                        if (!periodicSnapshotableMap.isEmpty()) {
                            elementWisePeriodicSnapshots.put(snapshotableObj.getElementId(), ByteSerializer.objectToByte(periodicSnapshotableMap, this.siddhiAppContext));
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"SnapshotState serialization finished.");
                    }
                    if (!elementWiseIncrementalSnapshots.isEmpty()) {
                        elementSnapshotMapIncremental.put(entry.getKey(), elementWiseIncrementalSnapshots);
                    }
                    if (!elementWiseIncrementalSnapshotsBase.isEmpty()) {
                        elementSnapshotMapIncrementalBase.put(entry.getKey(), elementWiseIncrementalSnapshotsBase);
                    }
                    if (elementWisePeriodicSnapshots.isEmpty()) continue;
                    elementSnapshotMapPeriodic.put(entry.getKey(), elementWisePeriodicSnapshots);
                }
            }
            finally {
                this.threadBarrier.unlock();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("SnapshotState taken for Siddhi app '" + this.siddhiAppContext.getName() + "'"));
            }
            IncrementalSnapshot snapshot = new IncrementalSnapshot();
            if (!elementSnapshotMapIncremental.isEmpty()) {
                snapshot.setIncrementalState(elementSnapshotMapIncremental);
            }
            if (!elementSnapshotMapIncrementalBase.isEmpty()) {
                snapshot.setIncrementalStateBase(elementSnapshotMapIncrementalBase);
            }
            if (!elementSnapshotMapPeriodic.isEmpty()) {
                snapshot.setPeriodicState(elementSnapshotMapPeriodic);
            }
            IncrementalSnapshot incrementalSnapshot = snapshot;
            return incrementalSnapshot;
        }
        finally {
            SnapshotRequest.requestForFullSnapshot(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> queryState(String queryName) {
        HashMap<String, Object> state = new HashMap<String, Object>();
        try {
            this.threadBarrier.lock();
            Map<String, Snapshotable> map = this.snapshotableMap.get(queryName);
            if (map != null) {
                for (Map.Entry<String, Snapshotable> entry : map.entrySet()) {
                    Snapshotable element = entry.getValue();
                    Map<String, Object> elementState = element.currentState();
                    String elementId = element.getElementId();
                    state.put(elementId, elementState);
                }
            }
        }
        finally {
            this.threadBarrier.unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Taking snapshot finished.");
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void restore(byte[] snapshot) throws CannotRestoreSiddhiAppStateException {
        if (snapshot == null) {
            throw new CannotRestoreSiddhiAppStateException("Restoring of Siddhi app " + this.siddhiAppContext.getName() + " failed due to no snapshot.");
        }
        Map snapshotsByQueryName = (Map)ByteSerializer.byteToObject(snapshot, this.siddhiAppContext);
        if (snapshotsByQueryName == null) {
            throw new CannotRestoreSiddhiAppStateException("Restoring of Siddhi app " + this.siddhiAppContext.getName() + " failed due to invalid snapshot.");
        }
        try {
            this.threadBarrier.lock();
            if (this.snapshotableMap.containsKey("partition")) {
                Map<String, Snapshotable> partitionSnapshotables = this.snapshotableMap.get("partition");
                try {
                    if (partitionSnapshotables != null) {
                        for (Map.Entry<String, Snapshotable> entry : partitionSnapshotables.entrySet()) {
                            Snapshotable snapshotable = entry.getValue();
                            Map map = (Map)snapshotsByQueryName.get("partition");
                            snapshotable.restoreState((Map)map.get(snapshotable.getElementId()));
                        }
                    }
                }
                catch (Throwable t) {
                    throw new CannotRestoreSiddhiAppStateException("Restoring of Siddhi app " + this.siddhiAppContext.getName() + " not completed properly. This can occur if the content of Siddhi app has changed since it was last state persisted, or if the Siddhi app was not given a name. Make sure to provide a name to the Siddhi app by adding '@app:name('<a name>')' annotation and clean the persistence store if you have done modifications to the Siddhi app such that it can perform a fresh deployment.", t);
                }
            }
            for (Map.Entry<String, Map<String, Snapshotable>> entry : this.snapshotableMap.entrySet()) {
                if (entry.getKey().equals("partition")) continue;
                Map<String, Snapshotable> map = entry.getValue();
                try {
                    for (Map.Entry entry2 : map.entrySet()) {
                        Map snapshotsByKey;
                        Snapshotable snapshotable = (Snapshotable)entry2.getValue();
                        Map snapshotsByElementId = (Map)snapshotsByQueryName.get(entry.getKey());
                        if (snapshotsByElementId == null || (snapshotsByKey = (Map)snapshotsByElementId.get(snapshotable.getElementId())) == null) continue;
                        HashMap<String, Object> snapshotRestoresByKey = new HashMap<String, Object>();
                        for (Map.Entry snapshotsByKeyEntry : snapshotsByKey.entrySet()) {
                            if (snapshotsByKeyEntry.getValue() instanceof SnapshotState) {
                                SnapshotStateList snapshotStateList = new SnapshotStateList();
                                snapshotStateList.putSnapshotState(0L, (SnapshotState)snapshotsByKeyEntry.getValue());
                                snapshotRestoresByKey.put((String)snapshotsByKeyEntry.getKey(), snapshotStateList);
                                continue;
                            }
                            snapshotRestoresByKey.put((String)snapshotsByKeyEntry.getKey(), snapshotsByKeyEntry.getValue());
                        }
                        snapshotable.restoreState(snapshotRestoresByKey);
                    }
                }
                catch (Throwable t) {
                    throw new CannotRestoreSiddhiAppStateException("Restoring of Siddhi app " + this.siddhiAppContext.getName() + " not completed properly because content of Siddhi app has changed since last state persistence. Clean persistence store for a fresh deployment.", t);
                    return;
                }
            }
        }
        finally {
            this.threadBarrier.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void restore(Map<String, Map<String, Map<Long, Map<IncrementalSnapshotInfo, byte[]>>>> snapshot) throws CannotRestoreSiddhiAppStateException {
        try {
            this.threadBarrier.lock();
            if (this.snapshotableMap.containsKey("partition")) {
                Map<String, Snapshotable> partitionSnapshotables = this.snapshotableMap.get("partition");
                try {
                    if (partitionSnapshotables != null) {
                        for (Map.Entry<String, Snapshotable> snapshotableEntry : partitionSnapshotables.entrySet()) {
                            Snapshotable snapshotable = snapshotableEntry.getValue();
                            Map<String, Map<Long, Map<IncrementalSnapshotInfo, byte[]>>> map = snapshot.get("partition");
                            this.restoreIncrementalSnapshot(snapshotable, map);
                        }
                    }
                }
                catch (Throwable t) {
                    throw new CannotRestoreSiddhiAppStateException("Restoring of Siddhi app " + this.siddhiAppContext.getName() + " not completed properly because content of Siddhi app has changed since last state persistence. Clean persistence store for a fresh deployment.", t);
                }
            }
            for (Map.Entry<String, Map<String, Snapshotable>> entry : this.snapshotableMap.entrySet()) {
                if (entry.getKey().equals("partition")) continue;
                Map<String, Snapshotable> map = entry.getValue();
                try {
                    for (Map.Entry entry2 : map.entrySet()) {
                        Snapshotable snapshotable = (Snapshotable)entry2.getValue();
                        Map<String, Map<Long, Map<IncrementalSnapshotInfo, byte[]>>> incrementalStateByElementId = snapshot.get(entry.getKey());
                        this.restoreIncrementalSnapshot(snapshotable, incrementalStateByElementId);
                    }
                }
                catch (Throwable t) {
                    throw new CannotRestoreSiddhiAppStateException("Restoring of Siddhi app " + this.siddhiAppContext.getName() + " not completed properly because content of Siddhi app has changed since last state persistence. Clean persistence store for a fresh deployment.", t);
                    return;
                }
            }
        }
        finally {
            this.threadBarrier.unlock();
        }
    }

    private void restoreIncrementalSnapshot(Snapshotable snapshotable, Map<String, Map<Long, Map<IncrementalSnapshotInfo, byte[]>>> incrementalStateByElementId) {
        Map<Long, Map<IncrementalSnapshotInfo, byte[]>> incrementalStateByTime;
        if (incrementalStateByElementId != null && (incrementalStateByTime = incrementalStateByElementId.get(snapshotable.getElementId())) != null) {
            HashMap<String, Object> deserializedElementStateMap = new HashMap<String, Object>();
            for (Map.Entry<Long, Map<IncrementalSnapshotInfo, byte[]>> incrementalStateByTimeEntry : incrementalStateByTime.entrySet()) {
                for (Map.Entry<IncrementalSnapshotInfo, byte[]> incrementalStateByInfoEntry : incrementalStateByTimeEntry.getValue().entrySet()) {
                    Map singleIncrementSnapshot = (Map)ByteSerializer.byteToObject(incrementalStateByInfoEntry.getValue(), this.siddhiAppContext);
                    if (singleIncrementSnapshot == null) continue;
                    for (Map.Entry singleIncrementSnapshotEntry : singleIncrementSnapshot.entrySet()) {
                        if (singleIncrementSnapshotEntry.getValue() instanceof SnapshotState) {
                            SnapshotState snapshotState = (SnapshotState)singleIncrementSnapshotEntry.getValue();
                            SnapshotStateList snapshotStateList = (SnapshotStateList)deserializedElementStateMap.computeIfAbsent((String)singleIncrementSnapshotEntry.getKey(), k -> new SnapshotStateList());
                            if (snapshotState.isIncrementalSnapshot()) {
                                snapshotStateList.putSnapshotState(incrementalStateByTimeEntry.getKey(), snapshotState);
                                continue;
                            }
                            snapshotStateList.getSnapshotStates().clear();
                            snapshotStateList.putSnapshotState(incrementalStateByTimeEntry.getKey(), snapshotState);
                            continue;
                        }
                        deserializedElementStateMap.put((String)singleIncrementSnapshotEntry.getKey(), singleIncrementSnapshotEntry.getValue());
                    }
                }
            }
            snapshotable.restoreState(deserializedElementStateMap);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void restoreRevision(String revision) throws CannotRestoreSiddhiAppStateException {
        IncrementalSnapshotInfo restoreSnapshotInfo;
        List<IncrementalSnapshotInfo> incrementalSnapshotInfos;
        PersistenceStore persistenceStore = this.siddhiAppContext.getSiddhiContext().getPersistenceStore();
        IncrementalPersistenceStore incrementalPersistenceStore = this.siddhiAppContext.getSiddhiContext().getIncrementalPersistenceStore();
        String siddhiAppName = this.siddhiAppContext.getName();
        if (persistenceStore != null) {
            byte[] snapshot;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Restoring revision: " + revision + " ..."));
            }
            if ((snapshot = persistenceStore.load(this.siddhiAppContext.getName(), revision)) != null) {
                this.restore(snapshot);
                if (!log.isDebugEnabled()) return;
                log.debug((Object)("Restored revision: " + revision));
                return;
            }
            if (!log.isDebugEnabled()) throw new PersistenceStoreException("No data found for revision: " + revision);
            log.debug((Object)("No data found for revision: " + revision));
            throw new PersistenceStoreException("No data found for revision: " + revision);
        }
        if (incrementalPersistenceStore == null) throw new NoPersistenceStoreException("No persistence store assigned for siddhi app " + siddhiAppName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Restoring revision: " + revision + " ..."));
        }
        if ((incrementalSnapshotInfos = incrementalPersistenceStore.getListOfRevisionsToLoad((restoreSnapshotInfo = PersistenceHelper.convertRevision(revision)).getTime(), restoreSnapshotInfo.getSiddhiAppId())) == null) {
            if (!log.isDebugEnabled()) throw new PersistenceStoreException("No data found for revision: " + revision);
            log.debug((Object)("No data found for revision: " + revision));
            throw new PersistenceStoreException("No data found for revision: " + revision);
        }
        incrementalSnapshotInfos.sort(new Comparator<IncrementalSnapshotInfo>(){

            @Override
            public int compare(IncrementalSnapshotInfo o1, IncrementalSnapshotInfo o2) {
                int results = o1.getElementId().compareTo(o2.getElementId());
                if (results == 0 && (results = Long.compare(o2.getTime(), o1.getTime())) == 0) {
                    return o2.getType().compareTo(o1.getType());
                }
                return results;
            }
        });
        String lastElementId = null;
        boolean baseFound = false;
        boolean perioicFound = false;
        Iterator<IncrementalSnapshotInfo> iterator = incrementalSnapshotInfos.iterator();
        while (iterator.hasNext()) {
            IncrementalSnapshotInfo snapshotInfo;
            block13: {
                block11: {
                    block14: {
                        block12: {
                            snapshotInfo = iterator.next();
                            if (!snapshotInfo.getElementId().equals(lastElementId)) break block11;
                            if (!baseFound || snapshotInfo.getType() != IncrementalSnapshotInfo.SnapshotType.BASE && snapshotInfo.getType() != IncrementalSnapshotInfo.SnapshotType.INCREMENT) break block12;
                            iterator.remove();
                            break block13;
                        }
                        if (!perioicFound || snapshotInfo.getType() != IncrementalSnapshotInfo.SnapshotType.PERIODIC) break block14;
                        iterator.remove();
                        break block13;
                    }
                    if (snapshotInfo.getType() == IncrementalSnapshotInfo.SnapshotType.BASE) {
                        baseFound = true;
                        break block13;
                    } else if (snapshotInfo.getType() == IncrementalSnapshotInfo.SnapshotType.PERIODIC) {
                        perioicFound = true;
                    }
                    break block13;
                }
                baseFound = snapshotInfo.getType() == IncrementalSnapshotInfo.SnapshotType.BASE;
                perioicFound = snapshotInfo.getType() == IncrementalSnapshotInfo.SnapshotType.PERIODIC;
            }
            lastElementId = snapshotInfo.getElementId();
        }
        HashMap<String, Map<String, Map<Long, Map<IncrementalSnapshotInfo, byte[]>>>> incrementalState = new HashMap<String, Map<String, Map<Long, Map<IncrementalSnapshotInfo, byte[]>>>>();
        Iterator<IncrementalSnapshotInfo> iterator2 = incrementalSnapshotInfos.iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                this.restore(incrementalState);
                if (!log.isDebugEnabled()) return;
                log.debug((Object)("Restored revision: " + revision));
                return;
            }
            IncrementalSnapshotInfo snapshotInfo = iterator2.next();
            Map incrementalStateByElementId = incrementalState.computeIfAbsent(snapshotInfo.getQueryName(), k -> new TreeMap());
            Map incrementalStateByTime = incrementalStateByElementId.computeIfAbsent(snapshotInfo.getElementId(), k -> new TreeMap());
            Map incrementalStateByInfo = incrementalStateByTime.computeIfAbsent(snapshotInfo.getTime(), k -> new HashMap());
            incrementalStateByInfo.put(snapshotInfo, incrementalPersistenceStore.load(snapshotInfo));
        }
    }

    public String restoreLastRevision() throws CannotRestoreSiddhiAppStateException {
        String revision;
        PersistenceStore persistenceStore = this.siddhiAppContext.getSiddhiContext().getPersistenceStore();
        IncrementalPersistenceStore incrementalPersistenceStore = this.siddhiAppContext.getSiddhiContext().getIncrementalPersistenceStore();
        String siddhiAppName = this.siddhiAppContext.getName();
        if (persistenceStore != null) {
            revision = persistenceStore.getLastRevision(siddhiAppName);
        } else if (incrementalPersistenceStore != null) {
            revision = incrementalPersistenceStore.getLastRevision(siddhiAppName);
        } else {
            throw new NoPersistenceStoreException("No persistence store assigned for siddhi app " + siddhiAppName);
        }
        if (revision != null) {
            this.restoreRevision(revision);
        }
        return revision;
    }

    public void clearAllRevisions() throws CannotClearSiddhiAppStateException {
        PersistenceStore persistenceStore = this.siddhiAppContext.getSiddhiContext().getPersistenceStore();
        IncrementalPersistenceStore incrementalPersistenceStore = this.siddhiAppContext.getSiddhiContext().getIncrementalPersistenceStore();
        String siddhiAppName = this.siddhiAppContext.getName();
        if (persistenceStore != null) {
            persistenceStore.clearAllRevisions(siddhiAppName);
        } else if (incrementalPersistenceStore != null) {
            incrementalPersistenceStore.clearAllRevisions(siddhiAppName);
        } else {
            throw new NoPersistenceStoreException("No persistence store assigned for siddhi app " + siddhiAppName);
        }
    }
}

