/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.statistics.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.wso2.siddhi.core.util.statistics.BufferedEventsTracker;
import org.wso2.siddhi.core.util.statistics.EventBufferHolder;

public class SiddhiBufferedEventsMetric
implements BufferedEventsTracker {
    private ConcurrentMap<Object, ObjectMetric> registeredObjects = new ConcurrentHashMap<Object, ObjectMetric>();
    private MetricRegistry metricRegistry;

    public SiddhiBufferedEventsMetric(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    @Override
    public void registerEventBufferHolder(EventBufferHolder eventBufferHolder, String name) {
        if (this.registeredObjects.get(eventBufferHolder) == null) {
            this.registeredObjects.put(eventBufferHolder, new ObjectMetric(eventBufferHolder, name));
        }
    }

    @Override
    public String getName(EventBufferHolder eventBufferHolder) {
        if (this.registeredObjects.get(eventBufferHolder) != null) {
            return ((ObjectMetric)this.registeredObjects.get(eventBufferHolder)).getName();
        }
        return null;
    }

    class ObjectMetric {
        private final EventBufferHolder eventBufferHolder;
        private String name;

        public ObjectMetric(EventBufferHolder eventBufferHolder, String name) {
            this.eventBufferHolder = eventBufferHolder;
            this.name = name;
            this.initMetric();
        }

        public String getName() {
            return this.name;
        }

        private void initMetric() {
            SiddhiBufferedEventsMetric.this.metricRegistry.register(this.name, (Metric)new Gauge<Long>(){

                public Long getValue() {
                    try {
                        if (ObjectMetric.this.eventBufferHolder != null) {
                            return ObjectMetric.this.eventBufferHolder.getBufferedEvents();
                        }
                        return 0L;
                    }
                    catch (Throwable e) {
                        return 0L;
                    }
                }
            });
        }
    }
}

